/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.listeners;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerException;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobChainingJobListener
implements IJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobChainingJobListener.class);
    private final String m_sName;
    private final ICommonsMap<JobKey, JobKey> m_aChainLinks = new CommonsHashMap();

    public JobChainingJobListener(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sName = string;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public void addJobChainLink(JobKey jobKey, JobKey jobKey2) {
        ValueEnforcer.notNull((Object)jobKey, (String)"FirstJob");
        ValueEnforcer.notNull((Object)jobKey.getName(), (String)"FirstJob.Name");
        ValueEnforcer.notNull((Object)jobKey2, (String)"SecondJob");
        ValueEnforcer.notNull((Object)jobKey2.getName(), (String)"SecondJob.Name");
        this.m_aChainLinks.put((Object)jobKey, (Object)jobKey2);
    }

    @Override
    public void jobWasExecuted(@Nonnull IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        JobKey jobKey = (JobKey)this.m_aChainLinks.get((Object)iJobExecutionContext.getJobDetail().getKey());
        if (jobKey == null) {
            return;
        }
        LOGGER.info("Job '" + String.valueOf(iJobExecutionContext.getJobDetail().getKey()) + "' will now chain to Job '" + String.valueOf(jobKey) + "'");
        try {
            iJobExecutionContext.getScheduler().triggerJob(jobKey);
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Error encountered during chaining to Job '" + String.valueOf(jobKey) + "'", (Throwable)schedulerException);
        }
    }
}

