/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.base.array.ArrayHelper;
import com.helger.quartz.ICalendar;
import com.helger.quartz.impl.calendar.AbstractCalendar;
import jakarta.annotation.Nonnull;
import java.util.Calendar;
import java.util.TimeZone;

public class WeeklyCalendar
extends AbstractCalendar<WeeklyCalendar> {
    private boolean[] m_aExcludeDays = new boolean[8];
    private boolean m_bExcludeAll = false;

    public WeeklyCalendar(@Nonnull WeeklyCalendar weeklyCalendar) {
        super(weeklyCalendar);
        this.m_aExcludeDays = ArrayHelper.getCopy((boolean[])weeklyCalendar.m_aExcludeDays);
        this.m_bExcludeAll = weeklyCalendar.m_bExcludeAll;
    }

    public WeeklyCalendar() {
        this(null, null);
    }

    public WeeklyCalendar(ICalendar iCalendar) {
        this(iCalendar, null);
    }

    public WeeklyCalendar(TimeZone timeZone) {
        this(null, timeZone);
    }

    public WeeklyCalendar(ICalendar iCalendar, TimeZone timeZone) {
        super(iCalendar, timeZone);
        this.m_aExcludeDays[1] = true;
        this.m_aExcludeDays[7] = true;
        this.m_bExcludeAll = this.areAllDaysExcluded();
    }

    public boolean[] getDaysExcluded() {
        return this.m_aExcludeDays;
    }

    public boolean isDayExcluded(int n) {
        return this.m_aExcludeDays[n];
    }

    public void setDaysExcluded(boolean[] blArray) {
        if (blArray != null) {
            this.m_aExcludeDays = blArray;
            this.m_bExcludeAll = this.areAllDaysExcluded();
        }
    }

    public void setDayExcluded(int n, boolean bl) {
        this.m_aExcludeDays[n] = bl;
        this.m_bExcludeAll = this.areAllDaysExcluded();
    }

    public boolean areAllDaysExcluded() {
        return this.isDayExcluded(1) && this.isDayExcluded(2) && this.isDayExcluded(3) && this.isDayExcluded(4) && this.isDayExcluded(5) && this.isDayExcluded(6) && this.isDayExcluded(7);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.m_bExcludeAll) {
            return false;
        }
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        Calendar calendar = this.createJavaCalendar(l);
        int n = calendar.get(7);
        return !this.isDayExcluded(n);
    }

    @Override
    public long getNextIncludedTime(long l) {
        Calendar calendar;
        int n;
        if (this.m_bExcludeAll) {
            return 0L;
        }
        long l2 = l;
        long l3 = super.getNextIncludedTime(l2);
        if (l3 > 0L && l3 > l2) {
            l2 = l3;
        }
        if (!this.isDayExcluded(n = (calendar = this.getStartOfDayJavaCalendar(l2)).get(7))) {
            return l2;
        }
        while (this.isDayExcluded(n)) {
            calendar.add(5, 1);
            n = calendar.get(7);
        }
        return calendar.getTime().getTime();
    }

    @Override
    @Nonnull
    public WeeklyCalendar getClone() {
        return new WeeklyCalendar(this);
    }
}

