/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.quartz.ICalendar;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractCalendar<IMPLTYPE extends AbstractCalendar<IMPLTYPE>>
implements ICalendar,
ICloneable<IMPLTYPE> {
    private ICalendar m_aBaseCalendar;
    private String m_sDescription;
    private TimeZone m_aTimeZone;

    protected AbstractCalendar(@Nonnull AbstractCalendar<IMPLTYPE> abstractCalendar) {
        ValueEnforcer.notNull(abstractCalendar, (String)"Other");
        this.m_aBaseCalendar = abstractCalendar.m_aBaseCalendar;
        this.m_sDescription = abstractCalendar.m_sDescription;
        this.m_aTimeZone = abstractCalendar.m_aTimeZone;
    }

    public AbstractCalendar(@Nullable ICalendar iCalendar, @Nullable TimeZone timeZone) {
        this.setBaseCalendar(iCalendar);
        this.m_aTimeZone = timeZone;
    }

    @Override
    public final ICalendar getBaseCalendar() {
        return this.m_aBaseCalendar;
    }

    @Override
    public final void setBaseCalendar(@Nullable ICalendar iCalendar) {
        this.m_aBaseCalendar = iCalendar;
    }

    @Override
    public final String getDescription() {
        return this.m_sDescription;
    }

    @Override
    public final void setDescription(@Nullable String string) {
        this.m_sDescription = string;
    }

    @Nullable
    public TimeZone getTimeZone() {
        return this.m_aTimeZone;
    }

    public void setTimeZone(@Nullable TimeZone timeZone) {
        this.m_aTimeZone = timeZone;
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        return this.m_aBaseCalendar == null || this.m_aBaseCalendar.isTimeIncluded(l);
    }

    @Override
    public long getNextIncludedTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        if (this.m_aBaseCalendar != null) {
            return this.m_aBaseCalendar.getNextIncludedTime(l);
        }
        return l;
    }

    protected final Calendar createJavaCalendar(long l) {
        Calendar calendar = this.createJavaCalendar();
        calendar.setTime(new Date(l));
        return calendar;
    }

    protected final Calendar createJavaCalendar() {
        return Calendar.getInstance(this.getTimeZone() != null ? this.getTimeZone() : TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected final Calendar getStartOfDayJavaCalendar(long l) {
        Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected final Calendar getEndOfDayJavaCalendar(long l) {
        Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }
}

