/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.quartz.IJobListener;
import com.helger.quartz.IListenerManager;
import com.helger.quartz.IMatcher;
import com.helger.quartz.ISchedulerListener;
import com.helger.quartz.ITriggerListener;
import com.helger.quartz.JobKey;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.EverythingMatcher;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ListenerManager
implements IListenerManager {
    private final ICommonsMap<String, IJobListener> m_aGlobalJobListeners = new CommonsLinkedHashMap(10);
    private final ICommonsMap<String, ITriggerListener> m_aGlobalTriggerListeners = new CommonsLinkedHashMap(10);
    private final ICommonsMap<String, List<IMatcher<JobKey>>> m_aGlobalJobListenersMatchers = new CommonsLinkedHashMap(10);
    private final ICommonsMap<String, List<IMatcher<TriggerKey>>> m_aGlobalTriggerListenersMatchers = new CommonsLinkedHashMap(10);
    private final ICommonsList<ISchedulerListener> m_aSchedulerListeners = new CommonsArrayList(10);

    @Override
    @SafeVarargs
    public final void addJobListener(IJobListener iJobListener, IMatcher<JobKey> ... iMatcherArray) {
        this.addJobListener(iJobListener, (List<IMatcher<JobKey>>)new CommonsArrayList((Object[])iMatcherArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(IJobListener iJobListener, List<IMatcher<JobKey>> list) {
        if (iJobListener.getName() == null || iJobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            this.m_aGlobalJobListeners.put((Object)iJobListener.getName(), (Object)iJobListener);
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            if (list != null && !list.isEmpty()) {
                commonsArrayList.addAll(list);
            } else {
                commonsArrayList.add(EverythingMatcher.allJobs());
            }
            this.m_aGlobalJobListenersMatchers.put((Object)iJobListener.getName(), (Object)commonsArrayList);
        }
    }

    @Override
    public void addJobListener(IJobListener iJobListener) {
        this.addJobListener(iJobListener, (IMatcher<JobKey>)EverythingMatcher.allJobs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(IJobListener iJobListener, IMatcher<JobKey> iMatcher) {
        if (iJobListener.getName() == null || iJobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            this.m_aGlobalJobListeners.put((Object)iJobListener.getName(), (Object)iJobListener);
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            if (iMatcher != null) {
                commonsArrayList.add(iMatcher);
            } else {
                commonsArrayList.add(EverythingMatcher.allJobs());
            }
            this.m_aGlobalJobListenersMatchers.put((Object)iJobListener.getName(), (Object)commonsArrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addJobListenerMatcher(String string, IMatcher<JobKey> iMatcher) {
        if (iMatcher == null) {
            throw new IllegalArgumentException("Null value not acceptable.");
        }
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            List list = (List)this.m_aGlobalJobListenersMatchers.get((Object)string);
            if (list == null) {
                return false;
            }
            list.add(iMatcher);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobListenerMatcher(String string, IMatcher<JobKey> iMatcher) {
        if (iMatcher == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            List list = (List)this.m_aGlobalJobListenersMatchers.get((Object)string);
            if (list == null) {
                return false;
            }
            return list.remove(iMatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<IMatcher<JobKey>> getJobListenerMatchers(String string) {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            List list = (List)this.m_aGlobalJobListenersMatchers.get((Object)string);
            if (list == null) {
                return null;
            }
            return new CommonsArrayList((Collection)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setJobListenerMatchers(String string, @Nonnull List<IMatcher<JobKey>> list) {
        ValueEnforcer.notNull(list, (String)"Matchers");
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            List list2 = (List)this.m_aGlobalJobListenersMatchers.get((Object)string);
            if (list2 == null) {
                return false;
            }
            this.m_aGlobalJobListenersMatchers.put((Object)string, list);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobListener(String string) {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            return this.m_aGlobalJobListeners.remove((Object)string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<IJobListener> getJobListeners() {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            return this.m_aGlobalJobListeners.copyOfValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJobListener getJobListener(String string) {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aGlobalJobListeners;
        synchronized (iCommonsMap) {
            return (IJobListener)this.m_aGlobalJobListeners.get((Object)string);
        }
    }

    @Override
    @SafeVarargs
    public final void addTriggerListener(ITriggerListener iTriggerListener, IMatcher<TriggerKey> ... iMatcherArray) {
        this.addTriggerListener(iTriggerListener, Arrays.asList(iMatcherArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTriggerListener(ITriggerListener iTriggerListener, List<IMatcher<TriggerKey>> list) {
        if (iTriggerListener.getName() == null || iTriggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            this.m_aGlobalTriggerListeners.put((Object)iTriggerListener.getName(), (Object)iTriggerListener);
            ArrayList<IMatcher<TriggerKey>> arrayList = new ArrayList<IMatcher<TriggerKey>>();
            if (list != null && !list.isEmpty()) {
                arrayList.addAll(list);
            } else {
                arrayList.add(EverythingMatcher.allTriggers());
            }
            this.m_aGlobalTriggerListenersMatchers.put((Object)iTriggerListener.getName(), arrayList);
        }
    }

    @Override
    public void addTriggerListener(ITriggerListener iTriggerListener) {
        this.addTriggerListener(iTriggerListener, (IMatcher<TriggerKey>)EverythingMatcher.allTriggers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTriggerListener(ITriggerListener iTriggerListener, IMatcher<TriggerKey> iMatcher) {
        if (iMatcher == null) {
            throw new IllegalArgumentException("Null value not acceptable for matcher.");
        }
        if (iTriggerListener.getName() == null || iTriggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            this.m_aGlobalTriggerListeners.put((Object)iTriggerListener.getName(), (Object)iTriggerListener);
            ArrayList<IMatcher<TriggerKey>> arrayList = new ArrayList<IMatcher<TriggerKey>>();
            arrayList.add(iMatcher);
            this.m_aGlobalTriggerListenersMatchers.put((Object)iTriggerListener.getName(), arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTriggerListenerMatcher(String string, IMatcher<TriggerKey> iMatcher) {
        if (iMatcher == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            List list = (List)this.m_aGlobalTriggerListenersMatchers.get((Object)string);
            if (list == null) {
                return false;
            }
            list.add(iMatcher);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggerListenerMatcher(String string, IMatcher<TriggerKey> iMatcher) {
        if (iMatcher == null) {
            throw new IllegalArgumentException("Non-null value not acceptable.");
        }
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            List list = (List)this.m_aGlobalTriggerListenersMatchers.get((Object)string);
            if (list == null) {
                return false;
            }
            return list.remove(iMatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<IMatcher<TriggerKey>> getTriggerListenerMatchers(String string) {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            List list = (List)this.m_aGlobalTriggerListenersMatchers.get((Object)string);
            if (list == null) {
                return null;
            }
            return new CommonsArrayList((Collection)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTriggerListenerMatchers(String string, @Nonnull List<IMatcher<TriggerKey>> list) {
        ValueEnforcer.noNullValue(list, (String)"Matchers");
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            List list2 = (List)this.m_aGlobalTriggerListenersMatchers.get((Object)string);
            if (list2 == null) {
                return false;
            }
            this.m_aGlobalTriggerListenersMatchers.put((Object)string, list);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggerListener(String string) {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            return this.m_aGlobalTriggerListeners.remove((Object)string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<ITriggerListener> getTriggerListeners() {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            return this.m_aGlobalTriggerListeners.copyOfValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITriggerListener getTriggerListener(String string) {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aGlobalTriggerListeners;
        synchronized (iCommonsMap) {
            return (ITriggerListener)this.m_aGlobalTriggerListeners.get((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchedulerListener(ISchedulerListener iSchedulerListener) {
        ICommonsList<ISchedulerListener> iCommonsList = this.m_aSchedulerListeners;
        synchronized (iCommonsList) {
            this.m_aSchedulerListeners.add((Object)iSchedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSchedulerListener(ISchedulerListener iSchedulerListener) {
        ICommonsList<ISchedulerListener> iCommonsList = this.m_aSchedulerListeners;
        synchronized (iCommonsList) {
            return this.m_aSchedulerListeners.remove((Object)iSchedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<ISchedulerListener> getSchedulerListeners() {
        ICommonsList<ISchedulerListener> iCommonsList = this.m_aSchedulerListeners;
        synchronized (iCommonsList) {
            return (ICommonsList)this.m_aSchedulerListeners.getClone();
        }
    }
}

