/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.youtube;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.embedded.AbstractHCIFrame;
import com.helger.url.ISimpleURL;
import com.helger.url.URLBuilder;
import jakarta.annotation.Nonnull;
import java.util.Locale;

public class HCYouTubeIFrame
extends AbstractHCIFrame<HCYouTubeIFrame> {
    private static final String PREFIX = "http://www.youtube.com/embed/";
    private final URLBuilder m_aVideoURL;

    public HCYouTubeIFrame(@Nonnull @Nonempty String string) {
        this.m_aVideoURL = URLBuilder.of((String)(PREFIX + string));
    }

    public HCYouTubeIFrame(int n, int n2, @Nonnull @Nonempty String string) {
        this(string);
        this.setWidth(n);
        this.setHeight(n2);
    }

    @Nonnull
    public ISimpleURL getVideoURL() {
        return this.m_aVideoURL.build();
    }

    @Nonnull
    public HCYouTubeIFrame setAutoPlay(boolean bl) {
        this.m_aVideoURL.param("autoplay", bl ? "1" : "0");
        return this;
    }

    @Nonnull
    public HCYouTubeIFrame setAllowFullscreen(boolean bl) {
        this.m_aVideoURL.param("fs", bl ? "1" : "0");
        return this;
    }

    @Nonnull
    public HCYouTubeIFrame setShowRelated(boolean bl) {
        this.m_aVideoURL.param("rel", bl ? "1" : "0");
        return this;
    }

    @Nonnull
    public HCYouTubeIFrame setLanguage(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        ValueEnforcer.notEmpty((CharSequence)locale.getLanguage(), (String)"Locale.getLanguage");
        this.m_aVideoURL.param("hl", locale.getLanguage());
        return this;
    }

    protected void onFinalizeNodeState(IHCConversionSettingsToNode iHCConversionSettingsToNode, IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.setSrc(this.m_aVideoURL.build());
    }
}

