/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.typeahead.ETypeaheadRemoteRateLimitFunction;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class TypeaheadRemote
implements ICloneable<TypeaheadRemote> {
    public static final String JSON_URL = "url";
    public static final String JSON_DATA_TYPE = "dataType";
    public static final String JSON_CACHE = "cache";
    public static final String JSON_TIMEOUT = "timeout";
    public static final String JSON_WILDCARD = "wildcard";
    public static final String JSON_REPLACE = "replace";
    public static final String JSON_RATE_LIMIT_FN = "rateLimitFn";
    public static final String JSON_RATE_LIMIT_WAIT = "rateLimitWait";
    public static final String JSON_MAX_PARALLEL_REQUESTS = "maxParallelRequests";
    public static final String JSON_BEFORE_SEND = "beforeSend";
    public static final String JSON_FILTER = "filter";
    public static final String DEFAULT_DATA_TYPE = "json";
    public static final String DEFAULT_WILDCARD = "_query_";
    public static final ETypeaheadRemoteRateLimitFunction DEFAULT_RATE_LIMIT_FN = ETypeaheadRemoteRateLimitFunction.DEBOUNCE;
    public static final int DEFAULT_RATE_LIMIT_WAIT = 300;
    public static final int DEFAULT_MAX_PARALLEL_REQUESTS = 6;
    private final SimpleURL m_aURL;
    private String m_sDataType = "json";
    private ETriState m_eCache = ETriState.UNDEFINED;
    private int m_nTimeout;
    private String m_sWildcard = "_query_";
    private JSAnonymousFunction m_aReplace;
    private ETypeaheadRemoteRateLimitFunction m_eRateLimitFn = DEFAULT_RATE_LIMIT_FN;
    private int m_nRateLimitWait = 300;
    private int m_nMaxParallelRequests = 6;
    private JSAnonymousFunction m_aBeforeSend;
    private JSAnonymousFunction m_aFilter;

    public TypeaheadRemote(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        this.m_aURL = new SimpleURL((IURLData)iSimpleURL);
    }

    public TypeaheadRemote(@Nonnull TypeaheadRemote typeaheadRemote) {
        ValueEnforcer.notNull((Object)typeaheadRemote, (String)"Other");
        this.m_aURL = typeaheadRemote.m_aURL.getClone();
        this.m_sDataType = typeaheadRemote.m_sDataType;
        this.m_eCache = typeaheadRemote.m_eCache;
        this.m_nTimeout = typeaheadRemote.m_nTimeout;
        this.m_sWildcard = typeaheadRemote.m_sWildcard;
        this.m_aReplace = typeaheadRemote.m_aReplace;
        this.m_eRateLimitFn = typeaheadRemote.m_eRateLimitFn;
        this.m_nRateLimitWait = typeaheadRemote.m_nRateLimitWait;
        this.m_nMaxParallelRequests = typeaheadRemote.m_nMaxParallelRequests;
        this.m_aBeforeSend = typeaheadRemote.m_aBeforeSend;
        this.m_aFilter = typeaheadRemote.m_aFilter;
    }

    @Nonnull
    public ISimpleURL getURL() {
        return this.m_aURL;
    }

    @Nonnull
    public TypeaheadRemote setDataType(@Nonnull @Nonempty String string) {
        this.m_sDataType = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"DataType");
        return this;
    }

    @Nonnull
    @Nonempty
    public String getDataType() {
        return this.m_sDataType;
    }

    @Nonnull
    public TypeaheadRemote setCache(boolean bl) {
        return this.setCache(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public TypeaheadRemote setCache(@Nonnull ETriState eTriState) {
        this.m_eCache = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"Cache");
        return this;
    }

    @Nonnull
    public ETriState getCache() {
        return this.m_eCache;
    }

    @Nonnull
    public TypeaheadRemote setTimeout(int n) {
        this.m_nTimeout = n;
        return this;
    }

    public int getTimeout() {
        return this.m_nTimeout;
    }

    @Nonnull
    public TypeaheadRemote setWildcard(@Nullable String string) {
        this.m_sWildcard = string;
        return this;
    }

    @Nullable
    public String getWildcard() {
        return this.m_sWildcard;
    }

    @Nonnull
    public TypeaheadRemote setReplace(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aReplace = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getReplace() {
        return this.m_aReplace;
    }

    @Nonnull
    public TypeaheadRemote setRateLimitFn(@Nonnull ETypeaheadRemoteRateLimitFunction eTypeaheadRemoteRateLimitFunction) {
        this.m_eRateLimitFn = (ETypeaheadRemoteRateLimitFunction)((Object)ValueEnforcer.notNull((Object)((Object)eTypeaheadRemoteRateLimitFunction), (String)"RateLimitFunction"));
        return this;
    }

    @Nonnull
    public ETypeaheadRemoteRateLimitFunction getRateLimitFn() {
        return this.m_eRateLimitFn;
    }

    @Nonnull
    public TypeaheadRemote setRateLimitWait(@Nonnegative int n) {
        this.m_nRateLimitWait = ValueEnforcer.isGT0((int)n, (String)"RateLimitWait");
        return this;
    }

    @Nonnegative
    public int getRateLimitWait() {
        return this.m_nRateLimitWait;
    }

    @Nonnull
    public TypeaheadRemote setMaxParallelRequests(@Nonnegative int n) {
        this.m_nMaxParallelRequests = ValueEnforcer.isGT0((int)n, (String)"MaxParallelRequests");
        return this;
    }

    @Nonnegative
    public int getMaxParallelRequests() {
        return this.m_nMaxParallelRequests;
    }

    @Nonnull
    public TypeaheadRemote setBeforeSend(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aBeforeSend = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getBeforeSend() {
        return this.m_aBeforeSend;
    }

    @Nonnull
    public TypeaheadRemote setFilter(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aFilter = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getFilter() {
        return this.m_aFilter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add(JSON_URL, this.m_aURL.getAsString());
        if (!this.m_sDataType.equals(DEFAULT_DATA_TYPE)) {
            jSAssocArray.add(JSON_DATA_TYPE, this.m_sDataType);
        }
        if (this.m_eCache.isDefined()) {
            jSAssocArray.add(JSON_CACHE, this.m_eCache.getAsBooleanValue(false));
        }
        if (this.m_nTimeout != 0) {
            jSAssocArray.add(JSON_TIMEOUT, this.m_nTimeout);
        }
        if (this.m_sWildcard != null) {
            jSAssocArray.add(JSON_WILDCARD, this.m_sWildcard);
        }
        if (this.m_aReplace != null) {
            jSAssocArray.add(JSON_REPLACE, (IJSExpression)this.m_aReplace);
        }
        if (!this.m_eRateLimitFn.equals((Object)DEFAULT_RATE_LIMIT_FN)) {
            jSAssocArray.add(JSON_RATE_LIMIT_FN, this.m_eRateLimitFn.getValue());
        }
        if (this.m_nRateLimitWait != 300) {
            jSAssocArray.add(JSON_RATE_LIMIT_WAIT, this.m_nRateLimitWait);
        }
        if (this.m_nMaxParallelRequests != 6) {
            jSAssocArray.add(JSON_MAX_PARALLEL_REQUESTS, this.m_nMaxParallelRequests);
        }
        if (this.m_aBeforeSend != null) {
            jSAssocArray.add(JSON_BEFORE_SEND, (IJSExpression)this.m_aBeforeSend);
        }
        if (this.m_aFilter != null) {
            jSAssocArray.add(JSON_FILTER, (IJSExpression)this.m_aFilter);
        }
        return jSAssocArray;
    }

    @Nonnull
    public TypeaheadRemote getClone() {
        return new TypeaheadRemote(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URL", (Object)this.m_aURL).append(JSON_DATA_TYPE, (Object)this.m_sDataType).append(JSON_CACHE, (Enum)this.m_eCache).append(JSON_TIMEOUT, this.m_nTimeout).appendIfNotNull(JSON_WILDCARD, (Object)this.m_sWildcard).appendIfNotNull(JSON_REPLACE, (Object)this.m_aReplace).append(JSON_RATE_LIMIT_FN, (Enum)this.m_eRateLimitFn).append(JSON_RATE_LIMIT_WAIT, this.m_nRateLimitWait).append(JSON_MAX_PARALLEL_REQUESTS, this.m_nMaxParallelRequests).appendIfNotNull(JSON_BEFORE_SEND, (Object)this.m_aBeforeSend).appendIfNotNull(JSON_FILTER, (Object)this.m_aFilter).getToString();
    }
}

