/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class TypeaheadPrefetch
implements ICloneable<TypeaheadPrefetch> {
    public static final String JSON_URL = "url";
    public static final String JSON_TTL = "ttl";
    public static final String JSON_FILTER = "filter";
    public static final int DEFAULT_TTL = 86400000;
    private final SimpleURL m_aURL;
    private int m_nTTL = 86400000;
    private JSAnonymousFunction m_aFilter;

    public TypeaheadPrefetch(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        this.m_aURL = new SimpleURL((IURLData)iSimpleURL);
    }

    public TypeaheadPrefetch(@Nonnull TypeaheadPrefetch typeaheadPrefetch) {
        ValueEnforcer.notNull((Object)typeaheadPrefetch, (String)"Other");
        this.m_aURL = typeaheadPrefetch.m_aURL.getClone();
        this.m_nTTL = typeaheadPrefetch.m_nTTL;
        this.m_aFilter = typeaheadPrefetch.m_aFilter;
    }

    @Nonnull
    public ISimpleURL getURL() {
        return this.m_aURL;
    }

    @Nonnull
    public TypeaheadPrefetch setTTL(@Nonnegative int n) {
        if (n < 1) {
            throw new IllegalArgumentException("TTL is too small: " + n);
        }
        this.m_nTTL = n;
        return this;
    }

    @Nonnegative
    public int getTTL() {
        return this.m_nTTL;
    }

    @Nonnull
    public TypeaheadPrefetch setFilter(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aFilter = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getFilter() {
        return this.m_aFilter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add(JSON_URL, this.m_aURL.getAsString());
        if (this.m_nTTL != 86400000) {
            jSAssocArray.add(JSON_TTL, this.m_nTTL);
        }
        if (this.m_aFilter != null) {
            jSAssocArray.add(JSON_FILTER, (IJSExpression)this.m_aFilter);
        }
        return jSAssocArray;
    }

    @Nonnull
    public TypeaheadPrefetch getClone() {
        return new TypeaheadPrefetch(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URL", (Object)this.m_aURL).append(JSON_TTL, this.m_nTTL).appendIfNotNull(JSON_FILTER, (Object)this.m_aFilter).getToString();
    }
}

