/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCInput;
import com.helger.html.hc.html.forms.EHCAutoComplete;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.jquery.JQuerySelector;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSParam;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.uictrls.typeahead.ETypeaheadText;
import com.helger.photon.uictrls.typeahead.HCTypeahead;
import com.helger.photon.uictrls.typeahead.TypeaheadDataset;
import com.helger.photon.uictrls.typeahead.TypeaheadRemote;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import java.util.Locale;

public class TypeaheadEdit
extends AbstractHCInput<TypeaheadEdit> {
    public static final String JSON_ID = "id";
    private final IHCRequestField m_aRFHidden;
    private final String m_sHiddenFieldID;
    private final JSAnonymousFunction m_aSelectionCallback;
    private final HCTypeahead m_aScript;

    public TypeaheadEdit(@Nonnull IHCRequestField iHCRequestField, @Nonnull IHCRequestField iHCRequestField2, @Nonnull ISimpleURL iSimpleURL, @Nonnull Locale locale) {
        super(EHCInputType.TEXT);
        ValueEnforcer.notNull((Object)iHCRequestField, (String)"RequestFieldEdit");
        ValueEnforcer.notNull((Object)iHCRequestField2, (String)"RequestFieldHidden");
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"AjaxInvocationURL");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.setName(iHCRequestField.getFieldName());
        this.setValue(iHCRequestField.getRequestValue());
        this.setAutoComplete(EHCAutoComplete.OFF);
        this.setPlaceholder(ETypeaheadText.ENTER_SEARCH_STRING.getDisplayText(locale));
        this.m_aRFHidden = iHCRequestField2;
        this.m_sHiddenFieldID = GlobalIDFactory.getNewStringID();
        this.m_aSelectionCallback = new JSAnonymousFunction();
        this.m_aSelectionCallback.param("evt");
        JSParam jSParam = this.m_aSelectionCallback.param("datum");
        this.m_aSelectionCallback.param("dsname");
        this.m_aSelectionCallback.body().add((IJSStatement)((JQueryInvocation)JQuery.idRef((String)this.m_sHiddenFieldID).val((IJSExpression)jSParam.ref(JSON_ID))).change());
        SimpleURL simpleURL = new SimpleURL((IURLData)iSimpleURL).add("query", "_query_");
        TypeaheadRemote typeaheadRemote = new TypeaheadRemote((ISimpleURL)simpleURL).setCache(false);
        TypeaheadDataset typeaheadDataset = new TypeaheadDataset(this.m_sHiddenFieldID).setRemote(typeaheadRemote);
        this.m_aScript = new HCTypeahead(JQuerySelector.id((IHCHasID)this)).addDataset(typeaheadDataset).setOnSelected(this.m_aSelectionCallback);
    }

    @Nonnull
    @Nonempty
    public final String getHiddenFieldID() {
        return this.m_sHiddenFieldID;
    }

    @Nonnull
    public final JSAnonymousFunction getJSSelectionCallback() {
        return this.m_aSelectionCallback;
    }

    @Nonnull
    public final HCTypeahead getScript() {
        return this.m_aScript;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        iHCHasChildrenMutable.addChild((IHCNode)new HCHiddenField(this.m_aRFHidden).setID(this.m_sHiddenFieldID));
        iHCHasChildrenMutable.addChild((IHCNode)this.m_aScript);
    }
}

