/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IAddableByTrait;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.json.IHasJson;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;

@NotThreadSafe
public class TypeaheadDatum
implements IHasJson,
Comparable<TypeaheadDatum> {
    public static final String JSON_VALUE = "value";
    public static final String JSON_TOKENS = "tokens";
    public static final String JSON_ID = "id";
    private String m_sValue;
    private final ICommonsList<String> m_aTokens;
    private String m_sID;

    public TypeaheadDatum(@Nonnull String string) {
        this(string, (Collection<String>)TypeaheadDatum.getTokensFromValue(string));
    }

    public TypeaheadDatum(@Nonnull String string, @Nonnull Collection<String> collection) {
        this(string, collection, null);
    }

    public TypeaheadDatum(@Nonnull String string, @Nonnull Collection<String> collection, @Nullable String string2) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        ValueEnforcer.notEmpty(collection, (String)"Tokens");
        this.m_sValue = string;
        this.m_aTokens = new CommonsArrayList(collection);
        this.m_sID = string2;
    }

    @Nonnull
    public final String getValue() {
        return this.m_sValue;
    }

    public final void setValue(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        this.m_sValue = string;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<String> tokens() {
        return this.m_aTokens;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllTokens() {
        return (ICommonsList)this.m_aTokens.getClone();
    }

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    public final void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @ReturnsMutableCopy
    @OverrideOnDemand
    public IJsonObject getAsJson() {
        return (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)JSON_VALUE, (Object)this.m_sValue)).add((Object)JSON_TOKENS, (IAddableByTrait)((IJson)new JsonArray().addAll(this.m_aTokens)))).addIfNotNull((Object)JSON_ID, (Object)this.m_sID);
    }

    @Override
    public int compareTo(@Nonnull TypeaheadDatum typeaheadDatum) {
        return this.m_sValue.compareTo(typeaheadDatum.m_sValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TypeaheadDatum typeaheadDatum = (TypeaheadDatum)object;
        return this.m_sValue.equals(typeaheadDatum.m_sValue) && this.m_aTokens.equals(typeaheadDatum.m_aTokens);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).append(this.m_aTokens).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Value", (Object)this.m_sValue).append("Tokens", this.m_aTokens).appendIfNotNull("ID", (Object)this.m_sID).getToString();
    }

    @Nonnull
    public static TypeaheadDatum createWithID(@Nonnull String string, @Nullable String string2) {
        return new TypeaheadDatum(string, (Collection<String>)TypeaheadDatum.getTokensFromValue(string), string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getTokensFromValue(@Nonnull String string) {
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)StringHelper.trim((String)string), (String)"\\W+");
        CommonsArrayList commonsArrayList = new CommonsArrayList(stringArray.length);
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (string3.length() <= 0) continue;
            commonsArrayList.add((Object)string3);
        }
        return commonsArrayList;
    }
}

