/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSStringLiteral;
import com.helger.json.IJson;
import com.helger.photon.uictrls.typeahead.TypeaheadDatum;
import com.helger.photon.uictrls.typeahead.TypeaheadPrefetch;
import com.helger.photon.uictrls.typeahead.TypeaheadRemote;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TypeaheadDataset {
    public static final String JSON_NAME = "name";
    public static final String JSON_VALUE_KEY = "valueKey";
    public static final String JSON_LIMIT = "limit";
    public static final String JSON_TEMPLATE = "template";
    public static final String JSON_ENGINE = "engine";
    public static final String JSON_HEADER = "header";
    public static final String JSON_FOOTER = "footer";
    public static final String JSON_LOCAL = "local";
    public static final String JSON_PREFETCH = "prefetch";
    public static final String JSON_REMOTE = "remote";
    public static final String DEFAULT_VALUE_KEY = "value";
    public static final int DEFAULT_LIMIT = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeaheadDataset.class);
    private final String m_sName;
    private String m_sValueKey = "value";
    private int m_nLimit = 5;
    private IJSExpression m_aTemplate;
    private String m_sEngine;
    private IJSExpression m_aHeader;
    private IJSExpression m_aFooter;
    private ICommonsList<? extends TypeaheadDatum> m_aLocal;
    private TypeaheadPrefetch m_aPrefetch;
    private TypeaheadRemote m_aRemote;

    public TypeaheadDataset(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        this.m_sName = string;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public TypeaheadDataset setValueKey(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ValueKey");
        this.m_sValueKey = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getValueKey() {
        return this.m_sValueKey;
    }

    @Nonnull
    public TypeaheadDataset setLimit(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"Limit");
        this.m_nLimit = n;
        return this;
    }

    @Nonnegative
    public int getLimit() {
        return this.m_nLimit;
    }

    @Nonnull
    public TypeaheadDataset setTemplate(@Nullable String string) {
        return this.setTemplate((IJSExpression)(StringHelper.isNotEmpty((String)string) ? JSExpr.lit((String)string) : null));
    }

    @Nonnull
    public TypeaheadDataset setTemplate(@Nullable IJSExpression iJSExpression) {
        this.m_aTemplate = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression getTemplate() {
        return this.m_aTemplate;
    }

    @Nonnull
    public TypeaheadDataset setEngine(@Nullable String string) {
        this.m_sEngine = string;
        return this;
    }

    @Nullable
    public String getEngine() {
        return this.m_sEngine;
    }

    @Nonnull
    public TypeaheadDataset setHeader(@Nullable IHCNode iHCNode) {
        return this.setHeader(iHCNode != null ? HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode) : null);
    }

    @Nonnull
    public TypeaheadDataset setHeader(@Nullable String string) {
        return this.setHeader((IJSExpression)(StringHelper.isNotEmpty((String)string) ? JSExpr.lit((String)string) : null));
    }

    @Nonnull
    public TypeaheadDataset setHeader(@Nullable IJSExpression iJSExpression) {
        this.m_aHeader = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression getHeader() {
        return this.m_aHeader;
    }

    @Nonnull
    public TypeaheadDataset setFooter(@Nullable IHCNode iHCNode) {
        return this.setFooter(iHCNode != null ? HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode) : null);
    }

    @Nonnull
    public TypeaheadDataset setFooter(@Nullable String string) {
        return this.setFooter((IJSExpression)(StringHelper.isNotEmpty((String)string) ? JSExpr.lit((String)string) : null));
    }

    @Nonnull
    public TypeaheadDataset setFooter(@Nullable IJSExpression iJSExpression) {
        this.m_aFooter = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression getFooter() {
        return this.m_aFooter;
    }

    @Nonnull
    public TypeaheadDataset setLocal(TypeaheadDatum ... typeaheadDatumArray) {
        this.m_aLocal = typeaheadDatumArray == null ? null : new CommonsArrayList((Object[])typeaheadDatumArray);
        return this;
    }

    @Nonnull
    public TypeaheadDataset setLocal(@Nullable List<? extends TypeaheadDatum> list) {
        this.m_aLocal = list == null ? null : new CommonsArrayList(list);
        return this;
    }

    @Nullable
    public ICommonsList<? extends TypeaheadDatum> getLocal() {
        return this.m_aLocal == null ? null : (ICommonsList)this.m_aLocal.getClone();
    }

    @Nonnull
    public TypeaheadDataset setPrefetch(@Nullable ISimpleURL iSimpleURL) {
        return this.setPrefetch(iSimpleURL == null ? null : new TypeaheadPrefetch(iSimpleURL));
    }

    @Nonnull
    public TypeaheadDataset setPrefetch(@Nullable TypeaheadPrefetch typeaheadPrefetch) {
        this.m_aPrefetch = typeaheadPrefetch;
        return this;
    }

    @Nullable
    @ReturnsMutableObject
    public TypeaheadPrefetch prefetch() {
        return this.m_aPrefetch;
    }

    @Nonnull
    public TypeaheadDataset setRemote(@Nullable TypeaheadRemote typeaheadRemote) {
        this.m_aRemote = typeaheadRemote;
        return this;
    }

    @Nullable
    @ReturnsMutableObject
    public TypeaheadRemote remote() {
        return this.m_aRemote;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        if (this.m_aTemplate instanceof JSStringLiteral && StringHelper.isEmpty((String)this.m_sEngine)) {
            LOGGER.warn("If template is a String, engine must be set!");
        }
        if (this.m_aLocal == null && this.m_aPrefetch == null && this.m_aRemote == null) {
            LOGGER.warn("Either local, prefetch or remote must be set!");
        }
        if (this.m_aLocal != null && this.m_aPrefetch != null) {
            LOGGER.warn("Only local or prefetch should be used!");
        }
        if (this.m_aLocal != null && this.m_aRemote != null) {
            LOGGER.warn("Only local or remote should be used!");
        }
        if (this.m_aPrefetch != null && this.m_aRemote != null) {
            LOGGER.warn("Only prefetch or remote should be used!");
        }
        JSAssocArray jSAssocArray = new JSAssocArray().add(JSON_NAME, this.m_sName);
        if (!this.m_sValueKey.equals(DEFAULT_VALUE_KEY)) {
            jSAssocArray.add(JSON_VALUE_KEY, this.m_sValueKey);
        }
        if (this.m_nLimit != 5) {
            jSAssocArray.add(JSON_LIMIT, this.m_nLimit);
        }
        if (this.m_aTemplate != null) {
            jSAssocArray.add(JSON_TEMPLATE, this.m_aTemplate);
        }
        if (StringHelper.isNotEmpty((String)this.m_sEngine)) {
            jSAssocArray.add(JSON_ENGINE, this.m_sEngine);
        }
        if (this.m_aHeader != null) {
            jSAssocArray.add(JSON_HEADER, this.m_aHeader);
        }
        if (this.m_aFooter != null) {
            jSAssocArray.add(JSON_FOOTER, this.m_aFooter);
        }
        if (this.m_aLocal != null) {
            JSArray jSArray = new JSArray();
            for (TypeaheadDatum typeaheadDatum : this.m_aLocal) {
                jSArray.add((IJson)typeaheadDatum.getAsJson());
            }
            jSAssocArray.add(JSON_LOCAL, (IJSExpression)jSArray);
        }
        if (this.m_aPrefetch != null) {
            jSAssocArray.add(JSON_PREFETCH, (IJSExpression)this.m_aPrefetch.getAsJSObject());
        }
        if (this.m_aRemote != null) {
            jSAssocArray.add(JSON_REMOTE, (IJSExpression)this.m_aRemote.getAsJSObject());
        }
        return jSAssocArray;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append(JSON_NAME, (Object)this.m_sName).append(JSON_VALUE_KEY, (Object)this.m_sValueKey).append(JSON_LIMIT, this.m_nLimit).appendIfNotNull(JSON_TEMPLATE, (Object)this.m_aTemplate).appendIfNotNull(JSON_ENGINE, (Object)this.m_sEngine).appendIfNotNull(JSON_HEADER, (Object)this.m_aHeader).appendIfNotNull(JSON_FOOTER, (Object)this.m_aFooter).appendIfNotNull(JSON_LOCAL, this.m_aLocal).appendIfNotNull(JSON_PREFETCH, (Object)this.m_aPrefetch).appendIfNotNull(JSON_REMOTE, (Object)this.m_aRemote).getToString();
    }
}

