/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.script.AbstractHCScriptInline;
import com.helger.html.jquery.IJQuerySelector;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.EUICtrlsJSPathProvider;
import com.helger.photon.uictrls.typeahead.TypeaheadDataset;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@OutOfBandNode
public class HCTypeahead
extends AbstractHCScriptInline<HCTypeahead> {
    public static final ICSSClassProvider TT_QUERY = DefaultCSSClassProvider.create((String)"tt-query");
    public static final ICSSClassProvider TT_HINT = DefaultCSSClassProvider.create((String)"tt-hint");
    public static final ICSSClassProvider TT_DROPDOWN_MENU = DefaultCSSClassProvider.create((String)"tt-dropdown-menu");
    public static final ICSSClassProvider TT_SUGGESTIONS = DefaultCSSClassProvider.create((String)"tt-suggestions");
    public static final ICSSClassProvider TT_SUGGESTION = DefaultCSSClassProvider.create((String)"tt-suggestion");
    public static final ICSSClassProvider TT_IS_UNDER_CURSOR = DefaultCSSClassProvider.create((String)"tt-is-under-cursor");
    private final IJSExpression m_aSelector;
    private final ICommonsList<TypeaheadDataset> m_aDatasets = new CommonsArrayList();
    private JSAnonymousFunction m_aOnInitialized;
    private JSAnonymousFunction m_aOnOpened;
    private JSAnonymousFunction m_aOnClosed;
    private JSAnonymousFunction m_aOnSelected;
    private JSAnonymousFunction m_aOnAutoCompleted;

    public HCTypeahead(@Nonnull IJQuerySelector iJQuerySelector) {
        this((IJSExpression)iJQuerySelector.invoke());
    }

    public HCTypeahead(@Nonnull IJSExpression iJSExpression) {
        this.m_aSelector = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Selector");
    }

    @Nonnull
    public IJSExpression getSelector() {
        return this.m_aSelector;
    }

    @Nonnull
    public HCTypeahead addDataset(@Nonnull TypeaheadDataset typeaheadDataset) {
        ValueEnforcer.notNull((Object)typeaheadDataset, (String)"Dataset");
        this.m_aDatasets.add((Object)typeaheadDataset);
        return this;
    }

    @Nonnegative
    public int getDatasetCount() {
        return this.m_aDatasets.size();
    }

    @Nullable
    public TypeaheadDataset getFirstDataset() {
        return (TypeaheadDataset)this.m_aDatasets.getFirstOrNull();
    }

    @Nullable
    public TypeaheadDataset getDatasetAtIndex(@Nonnegative int n) {
        return (TypeaheadDataset)this.m_aDatasets.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<TypeaheadDataset> getAllDatasets() {
        return (ICommonsList)this.m_aDatasets.getClone();
    }

    @Nonnull
    public HCTypeahead setOnInitialized(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aOnInitialized = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getOnInitialized() {
        return this.m_aOnInitialized;
    }

    @Nonnull
    public HCTypeahead setOnOpened(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aOnOpened = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getOnOpened() {
        return this.m_aOnOpened;
    }

    @Nonnull
    public HCTypeahead setOnClosed(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aOnClosed = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getOnClosed() {
        return this.m_aOnClosed;
    }

    @Nonnull
    public HCTypeahead setOnSelected(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aOnSelected = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getOnSelected() {
        return this.m_aOnSelected;
    }

    @Nonnull
    public HCTypeahead setOnAutoCompleted(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aOnAutoCompleted = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getOnAutoCompleted() {
        return this.m_aOnAutoCompleted;
    }

    @Nullable
    public JSInvocation getAsJSObject() {
        if (this.m_aDatasets.isEmpty()) {
            throw new IllegalStateException("At least one dataset must be provided!");
        }
        JSInvocation jSInvocation = HCTypeahead.invoke(this.m_aSelector);
        if (this.m_aDatasets.size() == 1) {
            jSInvocation.arg((IJSExpression)((TypeaheadDataset)this.m_aDatasets.getFirstOrNull()).getAsJSObject());
        } else {
            JSArray jSArray = new JSArray();
            for (TypeaheadDataset typeaheadDataset : this.m_aDatasets) {
                jSArray.add((IJSExpression)typeaheadDataset.getAsJSObject());
            }
            jSInvocation.arg((IJSExpression)jSArray);
        }
        if (this.m_aOnInitialized != null) {
            jSInvocation = (JSInvocation)((JSInvocation)jSInvocation.invoke("on").arg("typeahead:initialized")).arg((IJSExpression)this.m_aOnInitialized);
        }
        if (this.m_aOnOpened != null) {
            jSInvocation = (JSInvocation)((JSInvocation)jSInvocation.invoke("on").arg("typeahead:opened")).arg((IJSExpression)this.m_aOnOpened);
        }
        if (this.m_aOnClosed != null) {
            jSInvocation = (JSInvocation)((JSInvocation)jSInvocation.invoke("on").arg("typeahead:closed")).arg((IJSExpression)this.m_aOnClosed);
        }
        if (this.m_aOnSelected != null) {
            jSInvocation = (JSInvocation)((JSInvocation)jSInvocation.invoke("on").arg("typeahead:selected")).arg((IJSExpression)this.m_aOnSelected);
        }
        if (this.m_aOnAutoCompleted != null) {
            jSInvocation = (JSInvocation)((JSInvocation)jSInvocation.invoke("on").arg("typeahead:autocompleted")).arg((IJSExpression)this.m_aOnAutoCompleted);
        }
        return jSInvocation;
    }

    @OverridingMethodsMustInvokeSuper
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.setJSCodeProvider((IHasJSCode)this.getAsJSObject());
    }

    @OverridingMethodsMustInvokeSuper
    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICtrlsJSPathProvider.TYPEAHEAD_0_9);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICtrlsJSPathProvider.TYPEAHEAD_PH);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selector", (Object)this.m_aSelector).append("datasets", this.m_aDatasets).appendIfNotNull("onInitialized", (Object)this.m_aOnInitialized).appendIfNotNull("onOpened", (Object)this.m_aOnOpened).appendIfNotNull("onClosed", (Object)this.m_aOnClosed).appendIfNotNull("onSelected", (Object)this.m_aOnSelected).appendIfNotNull("onAutoCompleted", (Object)this.m_aOnAutoCompleted).getToString();
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull IJSExpression iJSExpression) {
        return iJSExpression.invoke("typeahead");
    }

    @Nonnull
    public static JSInvocation typeaheadDestroy(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)HCTypeahead.invoke(iJSExpression).arg("destroy");
    }

    @Nonnull
    public static JSInvocation typeaheadSetQuery(@Nonnull IJSExpression iJSExpression, @Nonnull String string) {
        return (JSInvocation)((JSInvocation)HCTypeahead.invoke(iJSExpression).arg("setQuery")).arg(string);
    }
}

