/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.typeahead;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.JsonArray;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.photon.core.ajax.executor.AbstractAjaxExecutorWithContext;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.uictrls.typeahead.ETypeaheadText;
import com.helger.photon.uictrls.typeahead.TypeaheadDatum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Locale;

public abstract class AbstractAjaxExecutorTypeaheadFinder<LECTYPE extends ILayoutExecutionContext>
extends AbstractAjaxExecutorWithContext<LECTYPE> {
    public static final String PARAM_QUERY = "query";
    private boolean m_bAddDatumCount = true;

    protected AbstractAjaxExecutorTypeaheadFinder() {
    }

    @Nullable
    @OverrideOnDemand
    protected String getQueryString(@Nonnull LECTYPE LECTYPE) {
        return LECTYPE.params().getAsString((Object)PARAM_QUERY);
    }

    @Nonnull
    @OverrideOnDemand
    protected Finder createFinder(@Nonnull String string, @Nonnull LECTYPE LECTYPE) {
        return new Finder(LECTYPE.getDisplayLocale()).initialize(string);
    }

    @Nonnull
    protected abstract ICommonsList<? extends TypeaheadDatum> getAllMatchingDatums(@Nonnull Finder var1, @Nonnull LECTYPE var2);

    public final boolean isAddDatumCount() {
        return this.m_bAddDatumCount;
    }

    public final void setAddDatumCount(boolean bl) {
        this.m_bAddDatumCount = bl;
    }

    protected void mainHandleRequest(@Nonnull LECTYPE LECTYPE, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        int n;
        String string = this.getQueryString(LECTYPE);
        if (StringHelper.isEmptyAfterTrim((String)string)) {
            photonUnifiedResponse.jsonEmpty();
            return;
        }
        Finder finder = this.createFinder(string, LECTYPE);
        ICommonsList<TypeaheadDatum> iCommonsList = this.getAllMatchingDatums(finder, LECTYPE);
        if (this.m_bAddDatumCount && (n = iCommonsList.size()) > 1) {
            Locale locale = LECTYPE.getDisplayLocale();
            String string2 = Integer.toString(n);
            int n2 = 0;
            for (TypeaheadDatum typeaheadDatum : iCommonsList) {
                String string3 = ETypeaheadText.DATUM_INDEX.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(++n2), string2});
                typeaheadDatum.setValue(typeaheadDatum.getValue() + " " + string3);
                typeaheadDatum.tokens().addAll(TypeaheadDatum.getTokensFromValue(string3));
            }
        }
        IJsonArray iJsonArray = (IJsonArray)new JsonArray().addAllMapped(iCommonsList, TypeaheadDatum::getAsJson);
        photonUnifiedResponse.json((IJson)iJsonArray);
    }

    @NotThreadSafe
    public static class Finder
    implements Serializable {
        private final Locale m_aSortLocale;
        private String[] m_aSearchTerms;

        protected Finder(@Nonnull Locale locale) {
            this.m_aSortLocale = (Locale)ValueEnforcer.notNull((Object)locale, (String)"SortLocale");
        }

        @Nonnull
        protected Finder initialize(@Nonnull @Nonempty String string) {
            if (StringHelper.isEmptyAfterTrim((String)string)) {
                throw new IllegalArgumentException("SearchTerms");
            }
            this.m_aSearchTerms = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
            if (this.m_aSearchTerms.length == 0) {
                throw new IllegalStateException("Weird - splitting of '" + string.trim() + "' failed!");
            }
            for (String string2 : this.m_aSearchTerms) {
                if (string2.length() != 0) continue;
                throw new IllegalArgumentException("Weird - empty search term present!");
            }
            return this;
        }

        @Nonnull
        @ReturnsMutableCopy
        @Nonempty
        public final String[] getAllSearchTerms() {
            return (String[])ArrayHelper.getCopy((Object[])this.m_aSearchTerms);
        }

        @Nonnull
        public final Locale getSortLocale() {
            return this.m_aSortLocale;
        }

        public boolean matches(@Nullable String string) {
            return this.matchesAll(string);
        }

        @OverrideOnDemand
        protected boolean isSingleStringMatching(@Nonnull String string, @Nonnull String string2) {
            return StringHelper.containsIgnoreCase((String)string, (String)string2, (Locale)this.m_aSortLocale);
        }

        public boolean matchesAll(@Nullable String string) {
            if (string == null) {
                return false;
            }
            for (String string2 : this.m_aSearchTerms) {
                if (this.isSingleStringMatching(string, string2)) continue;
                return false;
            }
            return true;
        }

        public boolean matchesAny(@Nullable String string) {
            if (string == null) {
                return false;
            }
            for (String string2 : this.m_aSearchTerms) {
                if (!this.isSingleStringMatching(string, string2)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("searchTerms", (Object[])this.m_aSearchTerms).append("sortLocale", (Object)this.m_aSortLocale).getToString();
        }
    }
}

