/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.prism;

import com.helger.css.property.CCSSProperties;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.ext.HCHasCSSClasses;
import com.helger.html.hc.ext.HCHasCSSStyles;
import com.helger.photon.uictrls.prism.IPrismPlugin;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class PrismPluginLineNumbers
implements IPrismPlugin {
    public static final ICSSClassProvider CSS_CLASS_LINE_NUMBERS = DefaultCSSClassProvider.create((String)"line-numbers");
    public static final ICSSClassProvider CSS_CLASS_NO_LINE_NUMBERS = DefaultCSSClassProvider.create((String)"no-line-numbers");
    private boolean m_bLineNumbers = true;
    private Integer m_aStart = null;
    private boolean m_bSoftWrap = false;

    @Nonnull
    public PrismPluginLineNumbers setLineNumbers(boolean bl) {
        this.m_bLineNumbers = bl;
        return this;
    }

    @Nonnull
    public PrismPluginLineNumbers setStart(int n) {
        return this.setStart((Integer)n);
    }

    @Nonnull
    public PrismPluginLineNumbers setStart(@Nullable Integer n) {
        this.m_aStart = n;
        return this;
    }

    @Nonnull
    public PrismPluginLineNumbers setSoftWrap(boolean bl) {
        this.m_bSoftWrap = bl;
        return this;
    }

    @Override
    public void applyOnPre(@Nonnull IMicroElement iMicroElement, @Nonnull HCHasCSSClasses hCHasCSSClasses, @Nonnull HCHasCSSStyles hCHasCSSStyles) {
        hCHasCSSClasses.addClass(this.m_bLineNumbers ? CSS_CLASS_LINE_NUMBERS : CSS_CLASS_NO_LINE_NUMBERS);
        if (this.m_aStart != null) {
            iMicroElement.setAttribute("data-start", this.m_aStart.intValue());
        }
        if (this.m_bSoftWrap) {
            hCHasCSSStyles.addStyle(CCSSProperties.WHITE_SPACE.newValue("pre-wrap"));
        }
    }
}

