/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.prism;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.writer.CSSWriterSettings;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.ext.HCHasCSSClasses;
import com.helger.html.hc.ext.HCHasCSSStyles;
import com.helger.html.hc.html.grouping.AbstractHCPre;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.EUICtrlsCSSPathProvider;
import com.helger.photon.uictrls.EUICtrlsJSPathProvider;
import com.helger.photon.uictrls.prism.EPrismLanguage;
import com.helger.photon.uictrls.prism.IPrismPlugin;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCPrismJS
extends AbstractHCPre<HCPrismJS> {
    public static final ICSSClassProvider CSS_CLASS_PRISMJS = DefaultCSSClassProvider.create((String)"prismjs");
    private ISimpleURL m_aSrc;
    private final EPrismLanguage m_eLanguage;
    private final ICommonsList<IPrismPlugin> m_aPlugins = new CommonsArrayList();

    public HCPrismJS(@Nonnull EPrismLanguage ePrismLanguage) {
        this.m_eLanguage = (EPrismLanguage)((Object)ValueEnforcer.notNull((Object)((Object)ePrismLanguage), (String)"Language"));
    }

    @Nonnull
    public final EPrismLanguage getPrismLanguage() {
        return this.m_eLanguage;
    }

    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Nullable
    public final HCPrismJS setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return this;
    }

    @Nonnull
    public final HCPrismJS addPlugin(@Nonnull IPrismPlugin iPrismPlugin) {
        ValueEnforcer.notNull((Object)iPrismPlugin, (String)"Plugin");
        this.m_aPlugins.add((Object)iPrismPlugin);
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        HCHasCSSClasses hCHasCSSClasses = new HCHasCSSClasses();
        hCHasCSSClasses.addClass(CSS_CLASS_PRISMJS);
        HCHasCSSStyles hCHasCSSStyles = new HCHasCSSStyles();
        for (IPrismPlugin iPrismPlugin : this.m_aPlugins) {
            iPrismPlugin.applyOnPre(iMicroElement, hCHasCSSClasses, hCHasCSSStyles);
        }
        if (hCHasCSSClasses.hasAnyClass()) {
            iMicroElement.setAttribute(CHTMLAttributes.CLASS, hCHasCSSClasses.getAllClassesAsString());
        }
        if (hCHasCSSStyles.hasAnyStyle()) {
            iMicroElement.setAttribute(CHTMLAttributes.STYLE, hCHasCSSStyles.getAllStylesAsString((ICSSWriterSettings)new CSSWriterSettings()));
        }
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute("data-src", this.m_aSrc.getAsString());
            super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        } else {
            hCHasCSSClasses = iMicroElement.addElementNS(iMicroElement.getNamespaceURI(), EHTMLElement.CODE.getElementName());
            super.fillMicroElement((IMicroElement)hCHasCSSClasses, iHCConversionSettingsToNode);
            hCHasCSSStyles = new HCHasCSSClasses();
            hCHasCSSStyles.addClass((ICSSClassProvider)this.m_eLanguage);
            hCHasCSSClasses.setAttribute(CHTMLAttributes.CLASS, hCHasCSSStyles.getAllClassesAsString());
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        HCPrismJS.registerExternalResources(this.m_aPlugins);
    }

    public static void registerExternalResources(@Nullable Iterable<? extends IPrismPlugin> iterable) {
        if (iterable != null) {
            for (IPrismPlugin iPrismPlugin : iterable) {
                iPrismPlugin.registerExternalResourcesBeforePrism();
            }
        }
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICtrlsCSSPathProvider.PRISMJS);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICtrlsJSPathProvider.PRISMJS);
        if (iterable != null) {
            for (IPrismPlugin iPrismPlugin : iterable) {
                iPrismPlugin.registerExternalResourcesAfterPrism();
            }
        }
    }
}

