/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.prism;

import com.helger.annotation.Nonempty;
import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.core.configfile.EConfigurationFileSyntax;
import jakarta.annotation.Nonnull;

public enum EPrismLanguage implements ICSSClassProvider
{
    NONE("language-none"),
    APACHECONF("language-apacheconf"),
    C("language-c"),
    CLIKE("language-clike"),
    CPP("language-cpp"),
    CSHARP("language-csharp"),
    CSS("language-css"),
    HTTP("language-http"),
    INI("language-ini"),
    JAVA("language-java"),
    JAVASCRIPT("language-javascript"),
    LATEX("language-latex"),
    LESS("language-less"),
    MARKDOWN("language-markdown"),
    MARKUP("language-markup"),
    PHP("language-php"),
    REGEX("language-regex"),
    SCSS("language-scss"),
    SQL("language-sql"),
    WIKI("language-wiki"),
    YAML("language-yaml");

    private final String m_sCSSClass;

    private EPrismLanguage(String string2) {
        this.m_sCSSClass = string2;
    }

    @Nonnull
    @Nonempty
    public String getCSSClass() {
        return this.m_sCSSClass;
    }

    @Nonnull
    public static EPrismLanguage find(@Nonnull EConfigurationFileSyntax eConfigurationFileSyntax) {
        switch (eConfigurationFileSyntax) {
            case NONE: {
                return NONE;
            }
            case PROPERTIES: {
                return APACHECONF;
            }
            case XML: {
                return MARKUP;
            }
            case JSON: {
                return JAVASCRIPT;
            }
        }
        return NONE;
    }
}

