/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.pdfobject;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PDFObjectOptions {
    private IJSExpression m_aPage;
    private String m_sID;
    private String m_sWidth;
    private String m_sHeight;
    private IJSExpression m_aFallbackLink;

    @Nonnull
    public PDFObjectOptions setPage(int n) {
        this.m_aPage = JSExpr.lit((int)n);
        return this;
    }

    @Nonnull
    public PDFObjectOptions setPage(@Nullable String string) {
        this.m_aPage = string == null ? null : JSExpr.lit((String)string);
        return this;
    }

    @Nonnull
    public PDFObjectOptions setID(@Nullable String string) {
        this.m_sID = string;
        return this;
    }

    @Nonnull
    public PDFObjectOptions setWidth(@Nullable String string) {
        this.m_sWidth = string;
        return this;
    }

    @Nonnull
    public PDFObjectOptions setHeight(@Nullable String string) {
        this.m_sHeight = string;
        return this;
    }

    @Nonnull
    public PDFObjectOptions setFallbackLinkDisabled() {
        this.m_aFallbackLink = JSExpr.FALSE;
        return this;
    }

    @Nonnull
    public PDFObjectOptions setFallbackLink(@Nullable String string) {
        this.m_aFallbackLink = string == null ? null : JSExpr.lit((String)string);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aPage != null) {
            jSAssocArray.add("page", this.m_aPage);
        }
        if (this.m_sID != null) {
            jSAssocArray.add("id", this.m_sID);
        }
        if (this.m_sWidth != null) {
            jSAssocArray.add("width", this.m_sWidth);
        }
        if (this.m_sHeight != null) {
            jSAssocArray.add("height", this.m_sHeight);
        }
        if (this.m_aFallbackLink != null) {
            jSAssocArray.add("fallbackLink", this.m_aFallbackLink);
        }
        return jSAssocArray;
    }
}

