/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5.ui;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.html.JSHtml;
import com.helger.photon.uictrls.fineupload5.FineUploader5Core;
import com.helger.photon.uictrls.fineupload5.ui.EFineUploader5UIText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class FineUploader5UI
extends FineUploader5Core {
    public static final String DEFAULT_TEMPLATE = "qq-template";
    private String m_sElementID;
    private String m_sListElementID;
    private IJSExpression m_aShowMessage;
    private IJSExpression m_aShowConfirm;
    private IJSExpression m_aShowPrompt;
    private String m_sTemplateID = "qq-template";

    public FineUploader5UI(@Nonnull Locale locale) {
        super(locale);
    }

    @Nullable
    public String getElementID() {
        return this.m_sElementID;
    }

    @Nonnull
    public FineUploader5UI setElementID(@Nullable String string) {
        this.m_sElementID = string;
        return this;
    }

    @Nullable
    public String getListElementID() {
        return this.m_sListElementID;
    }

    @Nonnull
    public FineUploader5UI setListElementID(@Nullable String string) {
        this.m_sListElementID = string;
        return this;
    }

    @Nullable
    public IJSExpression getShowMessage() {
        return this.m_aShowMessage;
    }

    @Nonnull
    public FineUploader5UI setShowMessage(@Nullable IJSExpression iJSExpression) {
        this.m_aShowMessage = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression getShowConfirm() {
        return this.m_aShowConfirm;
    }

    @Nonnull
    public FineUploader5UI setShowConfirm(@Nullable IJSExpression iJSExpression) {
        this.m_aShowConfirm = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression getShowPrompt() {
        return this.m_aShowPrompt;
    }

    @Nonnull
    public FineUploader5UI setShowPrompt(@Nullable IJSExpression iJSExpression) {
        this.m_aShowPrompt = iJSExpression;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getTemplateID() {
        return this.m_sTemplateID;
    }

    @Nonnull
    public FineUploader5UI setTemplateID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TemplateID");
        this.m_sTemplateID = string;
        return this;
    }

    @Override
    protected void extendJSONPart(@Nonnull @Nonempty String string, @Nonnull JSAssocArray jSAssocArray, @Nullable Locale locale) {
        if (string.equals("deleteFile") && locale != null) {
            jSAssocArray.add("confirmMessage", EFineUploader5UIText.DELETE_FILE_CONFIRM_MESSAGE.getDisplayText(locale));
            jSAssocArray.add("deletingFailedText", EFineUploader5UIText.DELETE_FILE_DELETING_FAILED_TEXT.getDisplayText(locale));
            jSAssocArray.add("deletingStatusText", EFineUploader5UIText.DELETE_FILE_DELETING_STATUS_TEXT.getDisplayText(locale));
        }
    }

    @Override
    protected void extendJSON(@Nonnull JSAssocArray jSAssocArray, @Nullable Locale locale) {
        if (StringHelper.isEmpty((String)this.m_sElementID)) {
            jSAssocArray.add("element", (IJSExpression)JSHtml.documentGetElementById((String)this.m_sElementID));
        }
        if (StringHelper.isEmpty((String)this.m_sListElementID)) {
            jSAssocArray.add("listElement", (IJSExpression)JSHtml.documentGetElementById((String)this.m_sListElementID));
        }
        if (this.m_aShowMessage != null) {
            jSAssocArray.add("showMessage", this.m_aShowMessage);
        }
        if (this.m_aShowConfirm != null) {
            jSAssocArray.add("showConfirm", this.m_aShowConfirm);
        }
        if (this.m_aShowPrompt != null) {
            jSAssocArray.add("showPrompt", this.m_aShowPrompt);
        }
        if (!this.m_sTemplateID.equals(DEFAULT_TEMPLATE)) {
            jSAssocArray.add("template", (IJSExpression)JSHtml.documentGetElementById((String)this.m_sTemplateID));
        }
        if (locale != null) {
            JSAssocArray jSAssocArray2 = new JSAssocArray();
            jSAssocArray2.add("uploadButton", EFineUploader5UIText.UPLOAD_BUTTON.getDisplayText(locale));
            jSAssocArray2.add("cancelButton", EFineUploader5UIText.CANCEL_BUTTON.getDisplayText(locale));
            jSAssocArray2.add("retryButton", EFineUploader5UIText.RETRY_BUTTON.getDisplayText(locale));
            jSAssocArray2.add("failUpload", EFineUploader5UIText.FAIL_UPLOAD.getDisplayText(locale));
            jSAssocArray2.add("dragZone", EFineUploader5UIText.DRAG_ZONE.getDisplayText(locale));
            jSAssocArray2.add("dropProcessing", EFineUploader5UIText.DROP_PROCESSING.getDisplayText(locale));
            jSAssocArray2.add("formatProgress", EFineUploader5UIText.FORMAT_PROGRESS.getDisplayText(locale));
            jSAssocArray2.add("waitingForResponse", EFineUploader5UIText.WAITING_FOR_RESPONSE.getDisplayText(locale));
            jSAssocArray.add("text", (IJSExpression)jSAssocArray2);
        }
    }
}

