/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5.servlet;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.mime.CMimeType;
import com.helger.photon.core.interror.InternalErrorBuilder;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;

public abstract class AbstractFineUploader5Servlet
implements IXServletSimpleHandler {
    @Nonnull
    protected abstract Response handleUploadedFile(@Nonnull IRequestWebScopeWithoutResponse var1);

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        try {
            Response response = this.handleUploadedFile(iRequestWebScopeWithoutResponse);
            unifiedResponse.disableCaching().setContentAndCharset(response.getAsJsonString(), StandardCharsets.UTF_8).setMimeType(CMimeType.TEXT_PLAIN);
        }
        catch (Exception exception) {
            new InternalErrorBuilder().addCustomData("Error reason", "Internal error in fine uploader 5 servlet").setThrowable((Throwable)exception).setRequestScope(iRequestWebScopeWithoutResponse).handle();
            unifiedResponse.setStatus(400);
        }
    }

    @Immutable
    public static class Response {
        public static final String JSON_SUCCESS = "success";
        public static final String JSON_ERROR = "error";
        public static final String JSON_PREVENT_RETRY = "preventRetry";
        public static final String JSON_RESET = "reset";
        public static final String JSON_NEW_UUID = "newUuid";
        private final ESuccess m_eSuccess;
        private final String m_sErrorMsg;
        private final ETriState m_ePreventRetry;
        private final ETriState m_eReset;
        private final String m_sNewUUID;

        protected Response(@Nonnull ESuccess eSuccess, @Nullable String string, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2, @Nullable String string2) {
            this.m_eSuccess = (ESuccess)ValueEnforcer.notNull((Object)eSuccess, (String)"Success");
            this.m_sErrorMsg = string;
            this.m_ePreventRetry = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"PreventRetry");
            this.m_eReset = (ETriState)ValueEnforcer.notNull((Object)eTriState2, (String)"Reset");
            this.m_sNewUUID = string2;
        }

        @Nonnull
        protected IJsonObject getAsJson() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add((Object)JSON_SUCCESS, this.m_eSuccess.isSuccess());
            if (StringHelper.isNotEmpty((String)this.m_sErrorMsg)) {
                jsonObject.add((Object)JSON_ERROR, (Object)this.m_sErrorMsg);
            }
            if (this.m_ePreventRetry.isDefined()) {
                jsonObject.add((Object)JSON_PREVENT_RETRY, this.m_ePreventRetry.getAsBooleanValue());
            }
            if (this.m_eReset.isDefined()) {
                jsonObject.add((Object)JSON_RESET, this.m_eReset.getAsBooleanValue());
            }
            if (StringHelper.isNotEmpty((String)this.m_sNewUUID)) {
                jsonObject.add((Object)JSON_NEW_UUID, (Object)this.m_sNewUUID);
            }
            return jsonObject;
        }

        @Nonnull
        public String getAsJsonString() {
            return this.getAsJson().getAsJsonString();
        }

        @Nonnull
        public static Response createSuccess() {
            return Response.createSuccess(null);
        }

        @Nonnull
        public static Response createSuccess(@Nullable String string) {
            return new Response(ESuccess.SUCCESS, null, ETriState.UNDEFINED, ETriState.UNDEFINED, string);
        }

        @Nonnull
        public static Response createError(@Nullable String string) {
            return Response.createError(string, ETriState.UNDEFINED, ETriState.UNDEFINED);
        }

        @Nonnull
        public static Response createError(@Nullable String string, boolean bl, boolean bl2) {
            return Response.createError(string, ETriState.valueOf((boolean)bl), ETriState.valueOf((boolean)bl2));
        }

        @Nonnull
        public static Response createError(@Nullable String string, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2) {
            return new Response(ESuccess.FAILURE, string, eTriState, eTriState2, null);
        }
    }
}

