/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.mime.IMimeType;
import com.helger.photon.uictrls.fineupload5.IFineUploader5Part;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;

public class FineUploader5Validation
implements IFineUploader5Part {
    public static final int DEFAULT_VALIDATION_ITEM_LIMIT = 0;
    public static final int DEFAULT_VALIDATION_MIN_SIZE_LIMIT = 0;
    public static final int DEFAULT_VALIDATION_SIZE_LIMIT = 0;
    public static final boolean DEFAULT_VALIDATION_STOP_ON_FIRST_INVALID_FILE = true;
    public static final int DEFAULT_VALIDATION_IMAGE_MAX_HEIGHT = 0;
    public static final int DEFAULT_VALIDATION_IMAGE_MAX_WIDTH = 0;
    public static final int DEFAULT_VALIDATION_IMAGE_MIN_HEIGHT = 0;
    public static final int DEFAULT_VALIDATION_IMAGE_MIN_WIDTH = 0;
    private final ICommonsOrderedSet<IMimeType> m_aValidationAcceptFiles = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aValidationAllowedExtensions = new CommonsLinkedHashSet();
    private int m_nValidationItemLimit = 0;
    private int m_nValidationMinSizeLimit = 0;
    private int m_nValidationSizeLimit = 0;
    private boolean m_bValidationStopOnFirstInvalidFile = true;
    private int m_nValidationImageMaxHeight = 0;
    private int m_nValidationImageMaxWidth = 0;
    private int m_nValidationImageMinHeight = 0;
    private int m_nValidationImageMinWidth = 0;

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMimeType> getAllAcceptFiles() {
        return this.m_aValidationAcceptFiles.getClone();
    }

    @Nonnull
    public FineUploader5Validation setAcceptFiles(@Nullable Collection<? extends IMimeType> collection) {
        this.m_aValidationAcceptFiles.setAll(collection);
        return this;
    }

    @Nonnull
    public FineUploader5Validation addAcceptFiles(@Nullable Collection<? extends IMimeType> collection) {
        if (collection != null) {
            this.m_aValidationAcceptFiles.addAll(collection);
        }
        return this;
    }

    @Nonnull
    public FineUploader5Validation addAcceptFile(@Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"AcceptFile");
        this.m_aValidationAcceptFiles.add((Object)iMimeType);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllAllowedExtensions() {
        return this.m_aValidationAllowedExtensions.getClone();
    }

    @Nonnull
    public FineUploader5Validation setAllowedExtensions(@Nullable Collection<String> collection) {
        this.m_aValidationAllowedExtensions.setAll(collection);
        return this;
    }

    @Nonnull
    public FineUploader5Validation addAllowedExtensions(@Nullable Collection<String> collection) {
        if (collection != null) {
            this.m_aValidationAllowedExtensions.addAll(collection);
        }
        return this;
    }

    @Nonnull
    public FineUploader5Validation addAllowedExtension(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AllowedExtension");
        this.m_aValidationAllowedExtensions.add((Object)string);
        return this;
    }

    @Nonnegative
    public int getItemLimit() {
        return this.m_nValidationItemLimit;
    }

    @Nonnull
    public FineUploader5Validation setItemLimit(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ItemLimit");
        this.m_nValidationItemLimit = n;
        return this;
    }

    @Nonnegative
    public int getMinSizeLimit() {
        return this.m_nValidationMinSizeLimit;
    }

    @Nonnull
    public FineUploader5Validation setMinSizeLimit(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"MinSizeLimit");
        this.m_nValidationMinSizeLimit = n;
        return this;
    }

    @Nonnegative
    public int getSizeLimit() {
        return this.m_nValidationSizeLimit;
    }

    @Nonnull
    public FineUploader5Validation setSizeLimit(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"SizeLimit");
        this.m_nValidationSizeLimit = n;
        return this;
    }

    public boolean isStopOnFirstInvalidFile() {
        return this.m_bValidationStopOnFirstInvalidFile;
    }

    @Nonnull
    public FineUploader5Validation setStopOnFirstInvalidFile(boolean bl) {
        this.m_bValidationStopOnFirstInvalidFile = bl;
        return this;
    }

    @Nonnegative
    public int getImageMaxHeight() {
        return this.m_nValidationImageMaxHeight;
    }

    @Nonnull
    public FineUploader5Validation setImageMaxHeight(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ImageMaxHeight");
        this.m_nValidationImageMaxHeight = n;
        return this;
    }

    @Nonnegative
    public int getImageMaxWidth() {
        return this.m_nValidationImageMaxWidth;
    }

    @Nonnull
    public FineUploader5Validation setImageMaxWidth(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ImageMaxWidth");
        this.m_nValidationImageMaxWidth = n;
        return this;
    }

    @Nonnegative
    public int getImageMinHeight() {
        return this.m_nValidationImageMinHeight;
    }

    @Nonnull
    public FineUploader5Validation setImageMinHeight(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ImageMinHeight");
        this.m_nValidationImageMinHeight = n;
        return this;
    }

    @Nonnegative
    public int getImageMinWidth() {
        return this.m_nValidationImageMinWidth;
    }

    @Nonnull
    public FineUploader5Validation setImageMinWidth(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"ImageMinWidth");
        this.m_nValidationImageMinWidth = n;
        return this;
    }

    @Override
    @Nonnull
    public JSAssocArray getJSCode() {
        JSArray jSArray;
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aValidationAcceptFiles.isNotEmpty()) {
            jSArray = new JSArray();
            for (IMimeType iMimeType : this.m_aValidationAcceptFiles) {
                jSArray.add(iMimeType.getAsString());
            }
            jSAssocArray.add("acceptFiles", (IJSExpression)jSArray);
        }
        if (this.m_aValidationAllowedExtensions.isNotEmpty()) {
            jSAssocArray.add("allowedExtensions", (IJSExpression)new JSArray().addAll(this.m_aValidationAllowedExtensions));
        }
        if (this.m_nValidationItemLimit != 0) {
            jSAssocArray.add("itemLimit", this.m_nValidationSizeLimit);
        }
        if (this.m_nValidationMinSizeLimit != 0) {
            jSAssocArray.add("minSizeLimit", this.m_nValidationMinSizeLimit);
        }
        if (this.m_nValidationSizeLimit != 0) {
            jSAssocArray.add("sizeLimit", this.m_nValidationSizeLimit);
        }
        if (!this.m_bValidationStopOnFirstInvalidFile) {
            jSAssocArray.add("stopOnFirstInvalidFile", this.m_bValidationStopOnFirstInvalidFile);
        }
        jSArray = new JSAssocArray();
        if (this.m_nValidationImageMaxHeight != 0) {
            jSArray.add("maxHeight", this.m_nValidationImageMaxHeight);
        }
        if (this.m_nValidationImageMaxWidth != 0) {
            jSArray.add("maxWidth", this.m_nValidationImageMaxWidth);
        }
        if (this.m_nValidationImageMinHeight != 0) {
            jSArray.add("minHeight", this.m_nValidationImageMinHeight);
        }
        if (this.m_nValidationImageMinWidth != 0) {
            jSArray.add("minWidth", this.m_nValidationImageMinWidth);
        }
        if (!jSArray.isEmpty()) {
            jSAssocArray.add("image", (IJSExpression)jSArray);
        }
        return jSAssocArray;
    }
}

