/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.fineupload5.IFineUploader5Part;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

public class FineUploader5Session
implements IFineUploader5Part {
    public static final boolean DEFAULT_SESSION_REFRESH_ON_RESET = true;
    private final ICommonsOrderedMap<String, String> m_aSessionCustomHeaders = new CommonsLinkedHashMap();
    private ISimpleURL m_aSessionEndpoint;
    private final ICommonsOrderedMap<String, String> m_aSessionParams = new CommonsLinkedHashMap();
    private boolean m_bSessionRefreshOnReset = true;

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllCustomHeaders() {
        return this.m_aSessionCustomHeaders.getClone();
    }

    @Nonnull
    public FineUploader5Session setCustomHeaders(@Nullable Map<String, String> map) {
        this.m_aSessionCustomHeaders.setAll(map);
        return this;
    }

    @Nonnull
    public FineUploader5Session addCustomHeaders(@Nullable Map<String, String> map) {
        this.m_aSessionCustomHeaders.putAllIfNotNull(map);
        return this;
    }

    @Nonnull
    public FineUploader5Session addCustomHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aSessionCustomHeaders.put((Object)string, (Object)string2);
        return this;
    }

    @Nullable
    public ISimpleURL getEndpoint() {
        return this.m_aSessionEndpoint;
    }

    @Nonnull
    public FineUploader5Session setEndpoint(@Nullable ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"Endpoint");
        this.m_aSessionEndpoint = iSimpleURL;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllParams() {
        return this.m_aSessionParams.getClone();
    }

    @Nonnull
    public FineUploader5Session setParams(@Nullable Map<String, String> map) {
        this.m_aSessionParams.setAll(map);
        return this;
    }

    @Nonnull
    public FineUploader5Session addParams(@Nullable Map<String, String> map) {
        this.m_aSessionParams.putAllIfNotNull(map);
        return this;
    }

    @Nonnull
    public FineUploader5Session addParam(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aSessionParams.put((Object)string, (Object)string2);
        return this;
    }

    public boolean isRefreshOnReset() {
        return this.m_bSessionRefreshOnReset;
    }

    @Nonnull
    public FineUploader5Session setRefreshOnReset(boolean bl) {
        this.m_bSessionRefreshOnReset = bl;
        return this;
    }

    @Override
    @Nonnull
    public JSAssocArray getJSCode() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aSessionCustomHeaders.isNotEmpty()) {
            jSAssocArray.add("customHeaders", (IJSExpression)this.getAsJSAA((Map<String, String>)this.m_aSessionCustomHeaders));
        }
        if (this.m_aSessionEndpoint != null) {
            jSAssocArray.add("endpoint", this.m_aSessionEndpoint.getAsString());
        }
        if (this.m_aSessionParams.isNotEmpty()) {
            jSAssocArray.add("params", (IJSExpression)this.getAsJSAA((Map<String, String>)this.m_aSessionParams));
        }
        if (!this.m_bSessionRefreshOnReset) {
            jSAssocArray.add("refreshOnReset", this.m_bSessionRefreshOnReset);
        }
        return jSAssocArray;
    }
}

