/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.http.EHttpMethod;
import com.helger.photon.uictrls.fineupload5.IFineUploader5Part;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

public class FineUploader5Request
implements IFineUploader5Part {
    public static final ISimpleURL DEFAULT_REQUEST_ENDPOINT = new SimpleURL("/server/upload");
    public static final String DEFAULT_REQUEST_FILENAME_PARAM = "qqfilename";
    public static final boolean DEFAULT_REQUEST_FORCE_MULTIPART = true;
    public static final String DEFAULT_REQUEST_INPUT_NAME = "qqfile";
    public static final EHttpMethod DEFAULT_REQUEST_METHOD = EHttpMethod.POST;
    public static final boolean DEFAULT_REQUEST_PARAMS_IN_BODY = true;
    public static final String DEFAULT_REQUEST_UUID_NAME = "qquuid";
    public static final String DEFAULT_REQUEST_TOTAL_FILE_SIZE_NAME = "qqtotalfilesize";
    private final ICommonsOrderedMap<String, String> m_aRequestCustomHeaders = new CommonsLinkedHashMap();
    private ISimpleURL m_aRequestEndpoint = DEFAULT_REQUEST_ENDPOINT;
    private String m_sRequestFilenameParam = "qqfilename";
    private boolean m_bRequestForceMultipart = true;
    private String m_sRequestInputName = "qqfile";
    private EHttpMethod m_eRequestMethod = DEFAULT_REQUEST_METHOD;
    private final ICommonsOrderedMap<String, String> m_aRequestParams = new CommonsLinkedHashMap();
    private boolean m_bRequestParamsInBody = true;
    private String m_sRequestUUIDName = "qquuid";
    private String m_sRequestTotalFileSizeName = "qqtotalfilesize";

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllCustomHeaders() {
        return this.m_aRequestCustomHeaders.getClone();
    }

    @Nonnull
    public FineUploader5Request setCustomHeaders(@Nullable Map<String, String> map) {
        this.m_aRequestCustomHeaders.setAll(map);
        return this;
    }

    @Nonnull
    public FineUploader5Request addCustomHeaders(@Nullable Map<String, String> map) {
        this.m_aRequestCustomHeaders.putAllIfNotNull(map);
        return this;
    }

    @Nonnull
    public FineUploader5Request addCustomHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRequestCustomHeaders.put((Object)string, (Object)string2);
        return this;
    }

    @Nonnull
    public ISimpleURL getEndpoint() {
        return this.m_aRequestEndpoint;
    }

    @Nonnull
    public FineUploader5Request setEndpoint(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"RequestEndpoint");
        this.m_aRequestEndpoint = iSimpleURL;
        return this;
    }

    @Nonnull
    public String getFilenameParam() {
        return this.m_sRequestFilenameParam;
    }

    @Nonnull
    public FineUploader5Request setFilenameParam(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FilenameParam");
        this.m_sRequestFilenameParam = string;
        return this;
    }

    public boolean isForceMultipart() {
        return this.m_bRequestForceMultipart;
    }

    @Nonnull
    public FineUploader5Request setForceMultipart(boolean bl) {
        this.m_bRequestForceMultipart = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getInputName() {
        return this.m_sRequestInputName;
    }

    @Nonnull
    public FineUploader5Request setInputName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"InputName");
        this.m_sRequestInputName = string;
        return this;
    }

    @Nonnull
    public EHttpMethod getMethod() {
        return this.m_eRequestMethod;
    }

    @Nonnull
    public FineUploader5Request setMethod(@Nonnull EHttpMethod eHttpMethod) {
        ValueEnforcer.notNull((Object)eHttpMethod, (String)"Method");
        this.m_eRequestMethod = eHttpMethod;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllParams() {
        return this.m_aRequestParams.getClone();
    }

    @Nonnull
    public FineUploader5Request setParams(@Nullable Map<String, String> map) {
        this.m_aRequestParams.setAll(map);
        return this;
    }

    @Nonnull
    public FineUploader5Request addParams(@Nullable Map<String, String> map) {
        this.m_aRequestParams.putAllIfNotNull(map);
        return this;
    }

    @Nonnull
    public FineUploader5Request addParam(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRequestParams.put((Object)string, (Object)string2);
        return this;
    }

    public boolean isParamsInBody() {
        return this.m_bRequestParamsInBody;
    }

    @Nonnull
    public FineUploader5Request setParamsInBody(boolean bl) {
        this.m_bRequestParamsInBody = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getUUIDName() {
        return this.m_sRequestUUIDName;
    }

    @Nonnull
    public FineUploader5Request setUUIDName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UUIDName");
        this.m_sRequestUUIDName = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getTotalFileSizeName() {
        return this.m_sRequestTotalFileSizeName;
    }

    @Nonnull
    public FineUploader5Request setTotalFileSizeName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TotalFileSizeName");
        this.m_sRequestTotalFileSizeName = string;
        return this;
    }

    @Override
    @Nonnull
    public JSAssocArray getJSCode() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aRequestCustomHeaders.isNotEmpty()) {
            jSAssocArray.add("customHeaders", (IJSExpression)this.getAsJSAA((Map<String, String>)this.m_aRequestCustomHeaders));
        }
        if (!this.m_aRequestEndpoint.equals((Object)DEFAULT_REQUEST_ENDPOINT)) {
            jSAssocArray.add("endpoint", this.m_aRequestEndpoint.getAsString());
        }
        if (!this.m_sRequestFilenameParam.equals(DEFAULT_REQUEST_FILENAME_PARAM)) {
            jSAssocArray.add("filenameParam", this.m_sRequestFilenameParam);
        }
        if (!this.m_bRequestForceMultipart) {
            jSAssocArray.add("forceMultipart", this.m_bRequestForceMultipart);
        }
        if (!this.m_sRequestInputName.equals(DEFAULT_REQUEST_INPUT_NAME)) {
            jSAssocArray.add("inputName", this.m_sRequestInputName);
        }
        if (!this.m_eRequestMethod.equals((Object)DEFAULT_REQUEST_METHOD)) {
            jSAssocArray.add("method", this.m_eRequestMethod.getName());
        }
        if (this.m_aRequestParams.isNotEmpty()) {
            jSAssocArray.add("params", (IJSExpression)this.getAsJSAA((Map<String, String>)this.m_aRequestParams));
        }
        if (!this.m_bRequestParamsInBody) {
            jSAssocArray.add("paramsInBody", this.m_bRequestParamsInBody);
        }
        if (!this.m_sRequestUUIDName.equals(DEFAULT_REQUEST_UUID_NAME)) {
            jSAssocArray.add("uuidName", this.m_sRequestUUIDName);
        }
        if (!this.m_sRequestTotalFileSizeName.equals(DEFAULT_REQUEST_TOTAL_FILE_SIZE_NAME)) {
            jSAssocArray.add("totalFileSizeName", this.m_sRequestTotalFileSizeName);
        }
        return jSAssocArray;
    }
}

