/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.html.JSHtml;
import com.helger.photon.uictrls.fineupload5.EFineUploader5CoreText;
import com.helger.photon.uictrls.fineupload5.FineUploader5Blobs;
import com.helger.photon.uictrls.fineupload5.FineUploader5Chunking;
import com.helger.photon.uictrls.fineupload5.FineUploader5Cors;
import com.helger.photon.uictrls.fineupload5.FineUploader5DeleteFile;
import com.helger.photon.uictrls.fineupload5.FineUploader5Form;
import com.helger.photon.uictrls.fineupload5.FineUploader5Paste;
import com.helger.photon.uictrls.fineupload5.FineUploader5Request;
import com.helger.photon.uictrls.fineupload5.FineUploader5Resume;
import com.helger.photon.uictrls.fineupload5.FineUploader5Retry;
import com.helger.photon.uictrls.fineupload5.FineUploader5Session;
import com.helger.photon.uictrls.fineupload5.FineUploader5Validation;
import com.helger.photon.uictrls.fineupload5.FineUploader5Workarounds;
import com.helger.photon.uictrls.fineupload5.IFineUploader5Part;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Set;

public class FineUploader5Core
implements IFineUploader5Part {
    protected static final String KEY_MESSAGES = "messages";
    protected static final String KEY_TEXT = "text";
    protected static final String KEY_BLOBS = "blobs";
    protected static final String KEY_CHUNKING = "chunking";
    protected static final String KEY_CORS = "cors";
    protected static final String KEY_DELETE_FILE = "deleteFile";
    protected static final String KEY_FORM = "form";
    protected static final String KEY_PASTE = "paste";
    protected static final String KEY_RESUME = "resume";
    protected static final String KEY_RETRY = "retry";
    protected static final String KEY_REQUEST = "request";
    protected static final String KEY_SESSION = "session";
    protected static final String KEY_VALIDATION = "validation";
    protected static final String KEY_WORKAROUNDS = "workarounds";
    public static final boolean DEFAULT_CORE_AUTO_UPLOAD = true;
    public static final boolean DEFAULT_CORE_DEBUG = false;
    public static final boolean DEFAULT_CORE_DISABLE_CANCEL_FOR_FORM_UPLOADS = false;
    public static final int DEFAULT_CORE_MAX_CONNECTIONS = 3;
    public static final boolean DEFAULT_CORE_MULTIPLE = true;
    @CodingStyleguideUnaware
    public static final Set<String> DEFAULT_TEXT_SIZE_SYMBOLS = new CommonsLinkedHashSet((Object[])new String[]{"kB", "MB", "GB", "TB", "PB", "EB"}).getAsUnmodifiable();
    private final Locale m_aDisplayLocale;
    private boolean m_bCoreAutoUpload = true;
    private String m_sCoreButtonElementID;
    private boolean m_bCoreDebug = false;
    private boolean m_bCoreDisableCancelForFormUploads = false;
    private IJSExpression m_aCoreFormatFileName;
    private int m_nCoreMaxConnections = 3;
    private boolean m_bCoreMultiple = true;
    private final ICommonsOrderedSet<String> m_aTextSizeSymbols = new CommonsLinkedHashSet(DEFAULT_TEXT_SIZE_SYMBOLS);
    private final FineUploader5Blobs m_aBlobs = new FineUploader5Blobs();
    private final FineUploader5Chunking m_aChunking = new FineUploader5Chunking();
    private final FineUploader5Cors m_aCors = new FineUploader5Cors();
    private final FineUploader5DeleteFile m_aDeleteFile = new FineUploader5DeleteFile();
    private final FineUploader5Form m_aForm = new FineUploader5Form();
    private final FineUploader5Paste m_aPaste = new FineUploader5Paste();
    private final FineUploader5Resume m_aResume = new FineUploader5Resume();
    private final FineUploader5Retry m_aRetry = new FineUploader5Retry();
    private final FineUploader5Request m_aRequest = new FineUploader5Request();
    private final FineUploader5Session m_aSession = new FineUploader5Session();
    private final FineUploader5Validation m_aValidation = new FineUploader5Validation();
    private final FineUploader5Workarounds m_aWorkarounds = new FineUploader5Workarounds();

    public FineUploader5Core(@Nullable Locale locale) {
        this.m_aDisplayLocale = locale;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    public boolean isAutoUpload() {
        return this.m_bCoreAutoUpload;
    }

    @Nonnull
    public FineUploader5Core setAutoUpload(boolean bl) {
        this.m_bCoreAutoUpload = bl;
        return this;
    }

    @Nullable
    public String getButtonElementID() {
        return this.m_sCoreButtonElementID;
    }

    @Nonnull
    public FineUploader5Core setButtonElementID(@Nullable String string) {
        this.m_sCoreButtonElementID = string;
        return this;
    }

    public boolean isDebug() {
        return this.m_bCoreDebug;
    }

    @Nonnull
    public FineUploader5Core setDebug(boolean bl) {
        this.m_bCoreDebug = bl;
        return this;
    }

    public boolean isDisableCancelForFormUploads() {
        return this.m_bCoreDisableCancelForFormUploads;
    }

    @Nonnull
    public FineUploader5Core setDisableCancelForFormUploads(boolean bl) {
        this.m_bCoreDisableCancelForFormUploads = bl;
        return this;
    }

    @Nullable
    public IJSExpression getFormatFileName() {
        return this.m_aCoreFormatFileName;
    }

    @Nonnull
    public FineUploader5Core setFormatFileName(@Nullable IJSExpression iJSExpression) {
        this.m_aCoreFormatFileName = iJSExpression;
        return this;
    }

    @Nonnegative
    public int getMaxConnections() {
        return this.m_nCoreMaxConnections;
    }

    @Nonnull
    public FineUploader5Core setMaxConnections(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxConnections");
        this.m_nCoreMaxConnections = n;
        return this;
    }

    public boolean isMultiple() {
        return this.m_bCoreMultiple;
    }

    @Nonnull
    public FineUploader5Core setMultiple(boolean bl) {
        this.m_bCoreMultiple = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Blobs getBlobs() {
        return this.m_aBlobs;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Chunking getChunking() {
        return this.m_aChunking;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Cors getCors() {
        return this.m_aCors;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5DeleteFile getDeleteFile() {
        return this.m_aDeleteFile;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Form getForm() {
        return this.m_aForm;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Paste getPaste() {
        return this.m_aPaste;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Resume getResume() {
        return this.m_aResume;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Retry getRetry() {
        return this.m_aRetry;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Request getRequest() {
        return this.m_aRequest;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Session getSession() {
        return this.m_aSession;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Validation getValidation() {
        return this.m_aValidation;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public FineUploader5Workarounds getWorkarounds() {
        return this.m_aWorkarounds;
    }

    @OverrideOnDemand
    protected void extendJSONPart(@Nonnull @Nonempty String string, @Nonnull JSAssocArray jSAssocArray, @Nullable Locale locale) {
    }

    @OverrideOnDemand
    protected void extendJSON(@Nonnull JSAssocArray jSAssocArray, @Nullable Locale locale) {
    }

    private void _extendAndAdd(@Nonnull JSAssocArray jSAssocArray, @Nonnull @Nonempty String string, @Nonnull JSAssocArray jSAssocArray2) {
        this.extendJSONPart(string, jSAssocArray2, this.m_aDisplayLocale);
        jSAssocArray.add(string, (IJSExpression)jSAssocArray2);
    }

    @Override
    @Nonnull
    public JSAssocArray getJSCode() {
        JSAssocArray jSAssocArray;
        JSAssocArray jSAssocArray2 = new JSAssocArray();
        if (!this.m_bCoreAutoUpload) {
            jSAssocArray2.add("autoUpload", this.m_bCoreAutoUpload);
        }
        if (StringHelper.isNotEmpty((String)this.m_sCoreButtonElementID)) {
            jSAssocArray2.add("button", (IJSExpression)JSHtml.documentGetElementById((String)this.m_sCoreButtonElementID));
        }
        if (this.m_bCoreDebug) {
            jSAssocArray2.add("debug", this.m_bCoreDebug);
        }
        if (this.m_bCoreDisableCancelForFormUploads) {
            jSAssocArray2.add("disableCancelForFormUploads", this.m_bCoreDisableCancelForFormUploads);
        }
        if (this.m_aCoreFormatFileName != null) {
            jSAssocArray2.add("formatFileName", this.m_aCoreFormatFileName);
        }
        if (this.m_nCoreMaxConnections != 3) {
            jSAssocArray2.add("maxConnections", this.m_nCoreMaxConnections);
        }
        if (!this.m_bCoreMultiple) {
            jSAssocArray2.add("multiple", this.m_bCoreMultiple);
        }
        if (this.m_aDisplayLocale != null) {
            jSAssocArray = new JSAssocArray();
            jSAssocArray.add("emptyError", EFineUploader5CoreText.EMPTY_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("maxHeightImageError", EFineUploader5CoreText.MAX_HEIGHT_IMAGE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("maxWidthImageError", EFineUploader5CoreText.MAX_WIDTH_IMAGE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("minHeightImageError", EFineUploader5CoreText.MIN_HEIGHT_IMAGE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("minWidthImageError", EFineUploader5CoreText.MIN_WIDTH_IMAGE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("minSizeError", EFineUploader5CoreText.MIN_SIZE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("noFilesError", EFineUploader5CoreText.NO_FILES_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("onLeave", EFineUploader5CoreText.ON_LEAVE.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("retryFailTooManyItemsError", EFineUploader5CoreText.RETRY_FAIL_TOO_MANY_ITEMS_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("sizeError", EFineUploader5CoreText.SIZE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("tooManyItemsError", EFineUploader5CoreText.TOO_MANY_ITEMS_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("typeError", EFineUploader5CoreText.TYPE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("unsupportedBrowserIos8Safari", EFineUploader5CoreText.UNSUPPORTED_BROWSER_IOS8_SAFARI.getDisplayText(this.m_aDisplayLocale));
            this._extendAndAdd(jSAssocArray2, KEY_MESSAGES, jSAssocArray);
        }
        jSAssocArray = new JSAssocArray();
        if (this.m_aDisplayLocale != null) {
            jSAssocArray.add("defaultResponseError", EFineUploader5CoreText.DEFAULT_RESPONSE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("fileInputTitle", EFineUploader5CoreText.FILE_INPUT_TITLE.getDisplayText(this.m_aDisplayLocale));
        }
        if (!this.m_aTextSizeSymbols.equals(DEFAULT_TEXT_SIZE_SYMBOLS)) {
            jSAssocArray.add("sizeSymbols", (IJSExpression)new JSArray().addAll(this.m_aTextSizeSymbols));
        }
        this._extendAndAdd(jSAssocArray2, KEY_TEXT, jSAssocArray);
        this._extendAndAdd(jSAssocArray2, KEY_BLOBS, this.m_aBlobs.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_CHUNKING, this.m_aChunking.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_CORS, this.m_aCors.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_DELETE_FILE, this.m_aDeleteFile.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_FORM, this.m_aForm.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_PASTE, this.m_aPaste.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_RESUME, this.m_aResume.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_RETRY, this.m_aRetry.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_REQUEST, this.m_aRequest.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_SESSION, this.m_aSession.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_VALIDATION, this.m_aValidation.getJSCode());
        this._extendAndAdd(jSAssocArray2, KEY_WORKAROUNDS, this.m_aWorkarounds.getJSCode());
        this.extendJSON(jSAssocArray2, this.m_aDisplayLocale);
        return jSAssocArray2;
    }
}

