/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload5;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.fineupload5.IFineUploader5Part;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class FineUploader5Chunking
implements IFineUploader5Part {
    public static final boolean DEFAULT_CHUNKING_CONCURRENT_ENABLED = false;
    public static final boolean DEFAULT_CHUNKING_ENABLED = false;
    public static final boolean DEFAULT_CHUNKING_MANDATORY = false;
    public static final long DEFAULT_CHUNKING_PART_SIZE = 2000000L;
    public static final String DEFAULT_CHUNKING_PARAM_NAMES_CHUNK_SIZE = "qqchunksize";
    public static final String DEFAULT_CHUNKING_PARAM_NAMES_PART_BYTE_OFFSET = "qqpartbyteoffset";
    public static final String DEFAULT_CHUNKING_PARAM_NAMES_PART_INDEX = "qqpartindex";
    public static final String DEFAULT_CHUNKING_PARAM_NAMES_TOTAL_PARTS = "qqtotalparts";
    private boolean m_bChunkingConcurrentEnabled = false;
    private boolean m_bChunkingEnabled = false;
    private boolean m_bChunkingMandatory = false;
    private long m_nChunkingPartSize = 2000000L;
    private String m_sChunkingParamNamesChunkSize = "qqchunksize";
    private String m_sChunkingParamNamesPartByteOffset = "qqpartbyteoffset";
    private String m_sChunkingParamNamesPartIndex = "qqpartindex";
    private String m_sChunkingParamNamesTotalParts = "qqtotalparts";
    private ISimpleURL m_aChunkingSuccessEndpoint;

    public boolean isConcurrentEnabled() {
        return this.m_bChunkingConcurrentEnabled;
    }

    @Nonnull
    public FineUploader5Chunking setConcurrentEnabled(boolean bl) {
        this.m_bChunkingConcurrentEnabled = bl;
        return this;
    }

    public boolean isEnabled() {
        return this.m_bChunkingEnabled;
    }

    @Nonnull
    public FineUploader5Chunking setEnabled(boolean bl) {
        this.m_bChunkingEnabled = bl;
        return this;
    }

    public boolean isMandatory() {
        return this.m_bChunkingMandatory;
    }

    @Nonnull
    public FineUploader5Chunking setMandatory(boolean bl) {
        this.m_bChunkingMandatory = bl;
        return this;
    }

    public long getPartSize() {
        return this.m_nChunkingPartSize;
    }

    @Nonnull
    public FineUploader5Chunking setPartSize(@Nonnegative long l) {
        ValueEnforcer.isGT0((long)l, (String)"PartSize");
        this.m_nChunkingPartSize = l;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getParamNameChunkSize() {
        return this.m_sChunkingParamNamesChunkSize;
    }

    @Nonnull
    public FineUploader5Chunking setParamNameChunkSize(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ParamNameChunkSize");
        this.m_sChunkingParamNamesChunkSize = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getParamNamePartByteOffset() {
        return this.m_sChunkingParamNamesPartByteOffset;
    }

    @Nonnull
    public FineUploader5Chunking setParamNamePartByteOffset(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ParamNamePartByteOffset");
        this.m_sChunkingParamNamesPartByteOffset = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getParamNamePartIndex() {
        return this.m_sChunkingParamNamesPartIndex;
    }

    @Nonnull
    public FineUploader5Chunking setParamNamePartIndex(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ParamNamePartIndex");
        this.m_sChunkingParamNamesPartIndex = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getParamNameTotalParts() {
        return this.m_sChunkingParamNamesTotalParts;
    }

    @Nonnull
    public FineUploader5Chunking setParamNameTotalParts(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ParamNameTotalParts");
        this.m_sChunkingParamNamesTotalParts = string;
        return this;
    }

    @Nullable
    public ISimpleURL getSuccessEndpoint() {
        return this.m_aChunkingSuccessEndpoint;
    }

    @Nonnull
    public FineUploader5Chunking setSuccessEndpoint(@Nullable ISimpleURL iSimpleURL) {
        this.m_aChunkingSuccessEndpoint = iSimpleURL;
        return this;
    }

    @Override
    @Nonnull
    public JSAssocArray getJSCode() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_bChunkingConcurrentEnabled) {
            jSAssocArray.add("concurrent", (IJSExpression)new JSAssocArray().add("enabled", this.m_bChunkingConcurrentEnabled));
        }
        if (this.m_bChunkingEnabled) {
            jSAssocArray.add("enabled", this.m_bChunkingEnabled);
        }
        if (this.m_bChunkingMandatory) {
            jSAssocArray.add("mandatory", this.m_bChunkingMandatory);
        }
        if (this.m_nChunkingPartSize != 2000000L) {
            jSAssocArray.add("partSize", this.m_nChunkingPartSize);
        }
        JSAssocArray jSAssocArray2 = new JSAssocArray();
        if (!this.m_sChunkingParamNamesChunkSize.equals(DEFAULT_CHUNKING_PARAM_NAMES_CHUNK_SIZE)) {
            jSAssocArray.add("chunkSize", this.m_sChunkingParamNamesChunkSize);
        }
        if (!this.m_sChunkingParamNamesPartByteOffset.equals(DEFAULT_CHUNKING_PARAM_NAMES_PART_BYTE_OFFSET)) {
            jSAssocArray.add("partByteOffset", this.m_sChunkingParamNamesPartByteOffset);
        }
        if (!this.m_sChunkingParamNamesPartIndex.equals(DEFAULT_CHUNKING_PARAM_NAMES_PART_INDEX)) {
            jSAssocArray.add("partIndex", this.m_sChunkingParamNamesPartIndex);
        }
        if (!this.m_sChunkingParamNamesTotalParts.equals(DEFAULT_CHUNKING_PARAM_NAMES_TOTAL_PARTS)) {
            jSAssocArray.add("totalParts", this.m_sChunkingParamNamesTotalParts);
        }
        if (!jSAssocArray2.isEmpty()) {
            jSAssocArray.add("paramNames", (IJSExpression)jSAssocArray2);
        }
        if (this.m_aChunkingSuccessEndpoint != null) {
            jSAssocArray.add("success", (IJSExpression)new JSAssocArray().add("endpoint", this.m_aChunkingSuccessEndpoint.getAsString()));
        }
        return jSAssocArray;
    }
}

