/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.fineupload;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.html.JSHtml;
import com.helger.photon.uictrls.fineupload.EFineUploaderBasicText;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FineUploaderBasic {
    public static final boolean DEFAULT_DEBUG = false;
    public static final boolean DEFAULT_MULTIPLE = true;
    public static final int DEFAULT_MAX_CONNECTIONS = 3;
    public static final boolean DEFAULT_DISABLE_CANCEL_FOR_FORM_UPLOADS = false;
    public static final boolean DEFAULT_AUTO_UPLOAD = true;
    public static final ISimpleURL DEFAULT_REQUEST_ENDPOINT = new SimpleURL("/server/upload");
    public static final boolean DEFAULT_REQUEST_PARAMS_IN_BODY = false;
    public static final boolean DEFAULT_REQUEST_FORCE_MULTIPART = false;
    public static final String DEFAULT_REQUEST_INPUT_NAME = "qqfile";
    public static final int DEFAULT_VALIDATION_SIZE_LIMIT = 0;
    public static final int DEFAULT_VALIDATION_MIN_SIZE_LIMIT = 0;
    public static final boolean DEFAULT_VALIDATION_STOP_ON_FIRST_INVALID_FILE = true;
    public static final boolean DEFAULT_RETRY_ENABLE_AUTO = false;
    public static final int DEFAULT_RETRY_MAX_AUTO_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_AUTO_ATTEMPT_DELAY = 5;
    public static final String DEFAULT_RETRY_PREVENT_RETRY_RESPONSE_PROPERTY = "preventRetry";
    private final Locale m_aDisplayLocale;
    private boolean m_bDebug = false;
    private String m_sButtonElementID;
    private boolean m_bMultiple = true;
    private int m_nMaxConnections = 3;
    private boolean m_bDisableCancelForFormUploads = false;
    private boolean m_bAutoUpload = true;
    private ISimpleURL m_aRequestEndpoint = DEFAULT_REQUEST_ENDPOINT;
    private final ICommonsOrderedMap<String, String> m_aRequestParams = new CommonsLinkedHashMap();
    private boolean m_bRequestParamsInBody = false;
    private final ICommonsOrderedMap<String, String> m_aRequestCustomHeaders = new CommonsLinkedHashMap();
    private boolean m_bRequestForceMultipart = false;
    private String m_sRequestInputName = "qqfile";
    private final ICommonsOrderedSet<String> m_aValidationAllowedExtensions = new CommonsLinkedHashSet();
    private int m_nValidationSizeLimit = 0;
    private int m_nValidationMinSizeLimit = 0;
    private boolean m_bValidationStopOnFirstInvalidFile = true;
    private boolean m_bRetryEnableAuto = false;
    private int m_nRetryMaxAutoAttempts = 3;
    private int m_nRetryAutoAttemptDelay = 5;
    private String m_sRetryPreventRetryResponseProperty = "preventRetry";

    public FineUploaderBasic(@Nullable Locale locale) {
        this.m_aDisplayLocale = locale;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    @Nonnull
    public FineUploaderBasic setDebug(boolean bl) {
        this.m_bDebug = bl;
        return this;
    }

    @Nonnull
    public ISimpleURL getEndpoint() {
        return this.m_aRequestEndpoint;
    }

    @Nonnull
    public FineUploaderBasic setEndpoint(@Nonnull ISimpleURL iSimpleURL) {
        this.m_aRequestEndpoint = (ISimpleURL)ValueEnforcer.notNull((Object)iSimpleURL, (String)"RequestEndpoint");
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllParams() {
        return this.m_aRequestParams.getClone();
    }

    @Nonnull
    public FineUploaderBasic setParams(@Nullable Map<String, String> map) {
        this.m_aRequestParams.setAll(map);
        return this;
    }

    @Nonnull
    public FineUploaderBasic addParams(@Nullable Map<String, String> map) {
        this.m_aRequestParams.putAllIfNotNull(map);
        return this;
    }

    @Nonnull
    public FineUploaderBasic addParam(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRequestParams.put((Object)string, (Object)string2);
        return this;
    }

    public boolean isRequestParamsInBody() {
        return this.m_bRequestParamsInBody;
    }

    @Nonnull
    public FineUploaderBasic setRequestParamsInBody(boolean bl) {
        this.m_bRequestParamsInBody = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllCustomHeaders() {
        return this.m_aRequestCustomHeaders.getClone();
    }

    @Nonnull
    public FineUploaderBasic setCustomHeaders(@Nullable Map<String, String> map) {
        this.m_aRequestCustomHeaders.setAll(map);
        return this;
    }

    @Nonnull
    public FineUploaderBasic addCustomHeaders(@Nullable Map<String, String> map) {
        this.m_aRequestCustomHeaders.putAllIfNotNull(map);
        return this;
    }

    @Nonnull
    public FineUploaderBasic addCustomHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRequestCustomHeaders.put((Object)string, (Object)string2);
        return this;
    }

    public boolean isForceMultipart() {
        return this.m_bRequestForceMultipart;
    }

    @Nonnull
    public FineUploaderBasic setForceMultipart(boolean bl) {
        this.m_bRequestForceMultipart = bl;
        return this;
    }

    @Nullable
    public String getButtonElementID() {
        return this.m_sButtonElementID;
    }

    @Nonnull
    public FineUploaderBasic setButtonElementID(@Nullable String string) {
        this.m_sButtonElementID = string;
        return this;
    }

    public boolean isMultiple() {
        return this.m_bMultiple;
    }

    @Nonnull
    public FineUploaderBasic setMultiple(boolean bl) {
        this.m_bMultiple = bl;
        return this;
    }

    @Nonnegative
    public int getMaxConnections() {
        return this.m_nMaxConnections;
    }

    @Nonnull
    public FineUploaderBasic setMaxConnections(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxConnections");
        this.m_nMaxConnections = n;
        return this;
    }

    public boolean isDisableCancelForFormUploads() {
        return this.m_bDisableCancelForFormUploads;
    }

    @Nonnull
    public FineUploaderBasic setDisableCancelForFormUploads(boolean bl) {
        this.m_bDisableCancelForFormUploads = bl;
        return this;
    }

    public boolean isAutoUpload() {
        return this.m_bAutoUpload;
    }

    @Nonnull
    public FineUploaderBasic setAutoUpload(boolean bl) {
        this.m_bAutoUpload = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllAllowedExtensions() {
        return this.m_aValidationAllowedExtensions.getClone();
    }

    @Nonnull
    public FineUploaderBasic setAllowedExtensions(@Nullable Set<String> set) {
        this.m_aValidationAllowedExtensions.setAll(set);
        return this;
    }

    @Nonnull
    public FineUploaderBasic addAllowedExtensions(@Nullable Set<String> set) {
        if (set != null) {
            this.m_aValidationAllowedExtensions.addAll(set);
        }
        return this;
    }

    @Nonnull
    public FineUploaderBasic addAllowedExtension(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"allowedExtension");
        this.m_aValidationAllowedExtensions.add((Object)string);
        return this;
    }

    @Nonnegative
    public int getSizeLimit() {
        return this.m_nValidationSizeLimit;
    }

    @Nonnull
    public FineUploaderBasic setSizeLimit(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"SizeLimit");
        this.m_nValidationSizeLimit = n;
        return this;
    }

    @Nonnegative
    public int getMinSizeLimit() {
        return this.m_nValidationMinSizeLimit;
    }

    @Nonnull
    public FineUploaderBasic setMinSizeLimit(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"MinSizeLimit");
        this.m_nValidationMinSizeLimit = n;
        return this;
    }

    public boolean isStopOnFirstInvalidFile() {
        return this.m_bValidationStopOnFirstInvalidFile;
    }

    @Nonnull
    public FineUploaderBasic setStopOnFirstInvalidFile(boolean bl) {
        this.m_bValidationStopOnFirstInvalidFile = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getInputName() {
        return this.m_sRequestInputName;
    }

    @Nonnull
    public FineUploaderBasic setInputName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"InputName");
        this.m_sRequestInputName = string;
        return this;
    }

    public boolean isRetryEnableAuto() {
        return this.m_bRetryEnableAuto;
    }

    @Nonnull
    public FineUploaderBasic setRetryEnableAuto(boolean bl) {
        this.m_bRetryEnableAuto = bl;
        return this;
    }

    public int getRetryMaxAutoAttempts() {
        return this.m_nRetryMaxAutoAttempts;
    }

    @Nonnull
    public FineUploaderBasic setRetryMaxAutoAttempts(int n) {
        this.m_nRetryMaxAutoAttempts = n;
        return this;
    }

    public int getRetryAutoAttemptDelay() {
        return this.m_nRetryAutoAttemptDelay;
    }

    @Nonnull
    public FineUploaderBasic setRetryAutoAttemptDelay(int n) {
        this.m_nRetryAutoAttemptDelay = n;
        return this;
    }

    public String getRetryPreventRetryResponseProperty() {
        return this.m_sRetryPreventRetryResponseProperty;
    }

    @Nonnull
    public FineUploaderBasic setRetryPreventRetryResponseProperty(@Nullable String string) {
        this.m_sRetryPreventRetryResponseProperty = string;
        return this;
    }

    @OverrideOnDemand
    protected void extendJSON(@Nonnull JSAssocArray jSAssocArray, @Nullable Locale locale) {
    }

    @OverrideOnDemand
    protected void extendJSONMessages(@Nonnull JSAssocArray jSAssocArray, @Nonnull Locale locale) {
    }

    @Nonnull
    public final JSAssocArray getJSON() {
        JSAssocArray jSAssocArray;
        JSAssocArray jSAssocArray2 = new JSAssocArray();
        if (this.m_bDebug) {
            jSAssocArray2.add("debug", this.m_bDebug);
        }
        if (StringHelper.isNotEmpty((String)this.m_sButtonElementID)) {
            jSAssocArray2.add("button", (IJSExpression)JSHtml.documentGetElementById((String)this.m_sButtonElementID));
        }
        if (!this.m_bMultiple) {
            jSAssocArray2.add("multiple", this.m_bMultiple);
        }
        if (this.m_nMaxConnections != 3) {
            jSAssocArray2.add("maxConnections", this.m_nMaxConnections);
        }
        if (this.m_bDisableCancelForFormUploads) {
            jSAssocArray2.add("disableCancelForFormUploads", this.m_bDisableCancelForFormUploads);
        }
        if (!this.m_bAutoUpload) {
            jSAssocArray2.add("autoUpload", this.m_bAutoUpload);
        }
        JSAssocArray jSAssocArray3 = new JSAssocArray();
        if (!this.m_aRequestEndpoint.equals((Object)DEFAULT_REQUEST_ENDPOINT)) {
            jSAssocArray3.add("endpoint", this.m_aRequestEndpoint.getAsString());
        }
        if (this.m_aRequestParams.isNotEmpty()) {
            jSAssocArray = new JSAssocArray();
            for (Map.Entry entry : this.m_aRequestParams.entrySet()) {
                jSAssocArray.add((String)entry.getKey(), (String)entry.getValue());
            }
            jSAssocArray3.add("params", (IJSExpression)jSAssocArray);
        }
        if (this.m_bRequestParamsInBody) {
            jSAssocArray3.add("paramsInBody", this.m_bRequestParamsInBody);
        }
        if (this.m_aRequestCustomHeaders.isNotEmpty()) {
            jSAssocArray = new JSAssocArray();
            for (Map.Entry entry : this.m_aRequestCustomHeaders.entrySet()) {
                jSAssocArray.add((String)entry.getKey(), (String)entry.getValue());
            }
            jSAssocArray3.add("customHeaders", (IJSExpression)jSAssocArray);
        }
        if (this.m_bRequestForceMultipart) {
            jSAssocArray3.add("forceMultipart", this.m_bRequestForceMultipart);
        }
        if (!this.m_sRequestInputName.equals(DEFAULT_REQUEST_INPUT_NAME)) {
            jSAssocArray3.add("inputName", this.m_sRequestInputName);
        }
        if (!jSAssocArray3.isEmpty()) {
            jSAssocArray2.add("request", (IJSExpression)jSAssocArray3);
        }
        jSAssocArray3 = new JSAssocArray();
        if (this.m_aValidationAllowedExtensions.isNotEmpty()) {
            jSAssocArray3.add("allowedExtensions", (IJSExpression)new JSArray().addAll(this.m_aValidationAllowedExtensions));
        }
        if (this.m_nValidationSizeLimit != 0) {
            jSAssocArray3.add("sizeLimit", this.m_nValidationSizeLimit);
        }
        if (this.m_nValidationMinSizeLimit != 0) {
            jSAssocArray3.add("minSizeLimit", this.m_nValidationMinSizeLimit);
        }
        if (!this.m_bValidationStopOnFirstInvalidFile) {
            jSAssocArray3.add("stopOnFirstInvalidFile", this.m_bValidationStopOnFirstInvalidFile);
        }
        if (!jSAssocArray3.isEmpty()) {
            jSAssocArray2.add("validation", (IJSExpression)jSAssocArray3);
        }
        if (this.m_aDisplayLocale != null) {
            jSAssocArray3 = new JSAssocArray();
            jSAssocArray3.add("typeError", EFineUploaderBasicText.TYPE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray3.add("sizeError", EFineUploaderBasicText.SIZE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray3.add("minSizeError", EFineUploaderBasicText.MIN_SIZE_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray3.add("emptyError", EFineUploaderBasicText.EMPTY_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray3.add("noFilesError", EFineUploaderBasicText.NO_FILES_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray3.add("onLeave", EFineUploaderBasicText.ON_LEAVE.getDisplayText(this.m_aDisplayLocale));
            this.extendJSONMessages(jSAssocArray3, this.m_aDisplayLocale);
            jSAssocArray2.add("messages", (IJSExpression)jSAssocArray3);
        }
        jSAssocArray3 = new JSAssocArray();
        if (this.m_bRetryEnableAuto) {
            jSAssocArray3.add("enableAuto", this.m_bRetryEnableAuto);
        }
        if (this.m_nRetryMaxAutoAttempts != 3) {
            jSAssocArray3.add("maxAutoAttempts", this.m_nRetryMaxAutoAttempts);
        }
        if (this.m_nRetryAutoAttemptDelay != 5) {
            jSAssocArray3.add("autoAttemptDelay", this.m_nRetryAutoAttemptDelay);
        }
        if (!DEFAULT_RETRY_PREVENT_RETRY_RESPONSE_PROPERTY.equals(this.m_sRetryPreventRetryResponseProperty)) {
            jSAssocArray3.add("preventRetryResponseProperty", this.m_sRetryPreventRetryResponseProperty);
        }
        if (!jSAssocArray3.isEmpty()) {
            jSAssocArray2.add("retry", (IJSExpression)jSAssocArray3);
        }
        this.extendJSON(jSAssocArray2, this.m_aDisplayLocale);
        return jSAssocArray2;
    }
}

