/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.colorpicker;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.css.UncheckedCSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCInput;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.request.IHCRequestField;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.EUICtrlsCSSPathProvider;
import com.helger.photon.uictrls.EUICtrlsJSPathProvider;
import com.helger.photon.uictrls.colorpicker.ColorPickerOptions;
import jakarta.annotation.Nonnull;

public class HCColorPicker
extends AbstractHCInput<HCColorPicker> {
    public static final String CSS_CLASS_NAME_COLOR = "color";
    public static final ICSSClassProvider CSS_CLASS_COLOR = DefaultCSSClassProvider.create((String)"color");
    private ColorPickerOptions m_aOptions = new ColorPickerOptions();

    public HCColorPicker() {
    }

    public HCColorPicker(@Nonnull IHCRequestField iHCRequestField) {
        this();
        this.setName(iHCRequestField.getFieldName());
        this.setValue(iHCRequestField.getRequestValue());
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public ColorPickerOptions getOptions() {
        return this.m_aOptions;
    }

    @Nonnull
    public HCColorPicker setOptions(@Nonnull ColorPickerOptions colorPickerOptions) {
        ValueEnforcer.notNull((Object)colorPickerOptions, (String)"Options");
        this.m_aOptions = colorPickerOptions;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        JSAssocArray jSAssocArray = this.m_aOptions.getJSOptions();
        if (jSAssocArray.isEmpty()) {
            this.addClass(CSS_CLASS_COLOR);
        } else {
            String string = "color " + jSAssocArray.getJSCode();
            this.addClass((ICSSClassProvider)new UncheckedCSSClassProvider(string));
        }
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICtrlsJSPathProvider.JSCOLOR);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICtrlsCSSPathProvider.JSCOLOR);
    }
}

