/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.colorpicker;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.css.utils.ECSSColorName;
import com.helger.html.CHTMLAttributes;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.colorpicker.EColorPickerMode;
import com.helger.photon.uictrls.colorpicker.EColorPickerPosition;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class ColorPickerOptions {
    public static final boolean DEFAULT_REQUIRED = true;
    public static final boolean DEFAULT_ADJUST = true;
    public static final boolean DEFAULT_HASH = false;
    public static final boolean DEFAULT_CAPS = true;
    public static final boolean DEFAULT_SLIDER = true;
    public static final String DEFAULT_VALUE_ELEMENT = CHTMLAttributes.TARGET.getName();
    public static final String DEFAULT_STYLE_ELEMENT = CHTMLAttributes.TARGET.getName();
    public static final boolean DEFAULT_PICKER_ON_FOCUS = true;
    public static final EColorPickerMode DEFAULT_PICKER_MODE = EColorPickerMode.HSV;
    public static final EColorPickerPosition DEFAULT_PICKER_POSITION = EColorPickerPosition.BOTTOM;
    public static final boolean DEFAULT_PICKER_SMART_POSITION = true;
    public static final int DEFAULT_PICKER_BUTTON_HEIGHT = 20;
    public static final boolean DEFAULT_PICKER_CLOSABLE = false;
    public static final String DEFAULT_PICKER_CLOSE_TEXT = "Close";
    public static final String DEFAULT_PICKER_BUTTON_COLOR = ECSSColorName.BUTTONTEXT.getName();
    public static final int DEFAULT_PICKER_FACE_PX = 10;
    public static final String DEFAULT_PICKER_FACE_COLOR = ECSSColorName.THREEDFACE.getName();
    public static final int DEFAULT_PICKER_BORDER_PX = 1;
    public static final String DEFAULT_PICKER_BORDER_COLOR = ECSSColorName.THREEDHIGHLIGHT.getName() + " " + ECSSColorName.THREEDSHADOW.getName() + " " + ECSSColorName.THREEDSHADOW.getName() + " " + ECSSColorName.THREEDHIGHLIGHT.getName();
    public static final int DEFAULT_PICKER_INSET_PX = 1;
    public static final String DEFAULT_PICKER_INSET_COLOR = ECSSColorName.THREEDSHADOW.getName() + " " + ECSSColorName.THREEDHIGHLIGHT.getName() + " " + ECSSColorName.THREEDHIGHLIGHT.getName() + " " + ECSSColorName.THREEDSHADOW.getName();
    public static final int DEFAULT_PICKER_ZINDEX = 10000;
    private boolean m_bRequired = true;
    private boolean m_bAdjust = true;
    private boolean m_bHash = false;
    private boolean m_bCaps = true;
    private boolean m_bSlider = true;
    private String m_sValueElement = DEFAULT_VALUE_ELEMENT;
    private String m_sStyleElement = DEFAULT_STYLE_ELEMENT;
    private JSAnonymousFunction m_aOnImmediateChange = null;
    private boolean m_bPickerOnFocus = true;
    private EColorPickerMode m_ePickerMode = DEFAULT_PICKER_MODE;
    private EColorPickerPosition m_ePickerPosition = DEFAULT_PICKER_POSITION;
    private boolean m_bPickerSmartPosition = true;
    private int m_nPickerButtonHeight = 20;
    private boolean m_bPickerClosable = false;
    private String m_sPickerCloseText = "Close";
    private String m_sPickerButtonColor = DEFAULT_PICKER_BUTTON_COLOR;
    private int m_nPickerFacePx = 10;
    private String m_sPickerFaceColor = DEFAULT_PICKER_FACE_COLOR;
    private int m_nPickerBorderPx = 1;
    private String m_sPickerBorderColor = DEFAULT_PICKER_BORDER_COLOR;
    private int m_nPickerInsetPx = 1;
    private String m_sPickerInsetColor = DEFAULT_PICKER_INSET_COLOR;
    private int m_nPickerZIndex = 10000;

    public boolean isRequired() {
        return this.m_bRequired;
    }

    @Nonnull
    public ColorPickerOptions setRequired(boolean bl) {
        this.m_bRequired = bl;
        return this;
    }

    public boolean isAdjust() {
        return this.m_bAdjust;
    }

    @Nonnull
    public ColorPickerOptions setAdjust(boolean bl) {
        this.m_bAdjust = bl;
        return this;
    }

    public boolean isHash() {
        return this.m_bHash;
    }

    @Nonnull
    public ColorPickerOptions setHash(boolean bl) {
        this.m_bHash = bl;
        return this;
    }

    public boolean isCaps() {
        return this.m_bCaps;
    }

    @Nonnull
    public ColorPickerOptions setCaps(boolean bl) {
        this.m_bCaps = bl;
        return this;
    }

    public boolean isSlider() {
        return this.m_bSlider;
    }

    @Nonnull
    public ColorPickerOptions setSlider(boolean bl) {
        this.m_bSlider = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getValueElement() {
        return this.m_sValueElement;
    }

    @Nonnull
    public ColorPickerOptions setValueElement(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ValueElement");
        this.m_sValueElement = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getStyleElement() {
        return this.m_sStyleElement;
    }

    @Nonnull
    public ColorPickerOptions setStyleElement(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"StyleElement");
        this.m_sStyleElement = string;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getOnImmediateChange() {
        return this.m_aOnImmediateChange;
    }

    @Nonnull
    public ColorPickerOptions setOnImmediateChange(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aOnImmediateChange = jSAnonymousFunction;
        return this;
    }

    public boolean isPickerOnFocus() {
        return this.m_bPickerOnFocus;
    }

    @Nonnull
    public ColorPickerOptions setPickerOnFocus(boolean bl) {
        this.m_bPickerOnFocus = bl;
        return this;
    }

    @Nonnull
    public EColorPickerMode getPickerMode() {
        return this.m_ePickerMode;
    }

    @Nonnull
    public ColorPickerOptions setPickerMode(@Nonnull EColorPickerMode eColorPickerMode) {
        ValueEnforcer.notNull((Object)((Object)eColorPickerMode), (String)"PickerMode");
        this.m_ePickerMode = eColorPickerMode;
        return this;
    }

    @Nonnull
    public EColorPickerPosition getPickerPosition() {
        return this.m_ePickerPosition;
    }

    @Nonnull
    public ColorPickerOptions setPickerPosition(@Nonnull EColorPickerPosition eColorPickerPosition) {
        ValueEnforcer.notNull((Object)((Object)eColorPickerPosition), (String)"PickerPosition");
        this.m_ePickerPosition = eColorPickerPosition;
        return this;
    }

    public boolean isPickerSmartPosition() {
        return this.m_bPickerSmartPosition;
    }

    @Nonnull
    public ColorPickerOptions setPickerSmartPosition(boolean bl) {
        this.m_bPickerSmartPosition = bl;
        return this;
    }

    @Nonnegative
    public int getPickerButtonHeight() {
        return this.m_nPickerButtonHeight;
    }

    @Nonnull
    public ColorPickerOptions setPickerButtonHeight(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"PickerButtonHeight");
        this.m_nPickerButtonHeight = n;
        return this;
    }

    public boolean isPickerClosable() {
        return this.m_bPickerClosable;
    }

    @Nonnull
    public ColorPickerOptions setPickerClosable(boolean bl) {
        this.m_bPickerClosable = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getPickerCloseText() {
        return this.m_sPickerCloseText;
    }

    @Nonnull
    public ColorPickerOptions setPickerCloseText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PickerCloseText");
        this.m_sPickerCloseText = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getPickerButtonColor() {
        return this.m_sPickerButtonColor;
    }

    @Nonnull
    public ColorPickerOptions setPickerButtonColor(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PickerButtonColor");
        this.m_sPickerButtonColor = string;
        return this;
    }

    @Nonnegative
    public int getPickerFacePx() {
        return this.m_nPickerFacePx;
    }

    @Nonnull
    public ColorPickerOptions setPickerFacePx(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"PickerFacePx");
        this.m_nPickerFacePx = n;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getPickerFaceColor() {
        return this.m_sPickerFaceColor;
    }

    @Nonnull
    public ColorPickerOptions setPickerFaceColor(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PickerFaceColor");
        this.m_sPickerFaceColor = string;
        return this;
    }

    @Nonnegative
    public int getPickerBorderPx() {
        return this.m_nPickerBorderPx;
    }

    @Nonnull
    public ColorPickerOptions setPickerBorderPx(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"PickerBorderPx");
        this.m_nPickerBorderPx = n;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getPickerBorderColor() {
        return this.m_sPickerBorderColor;
    }

    @Nonnull
    public ColorPickerOptions setPickerBorderColor(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PickerBorderColor");
        this.m_sPickerBorderColor = string;
        return this;
    }

    @Nonnegative
    public int getPickerInsetPx() {
        return this.m_nPickerInsetPx;
    }

    @Nonnull
    public ColorPickerOptions setPickerInsetPx(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"PickerInsetPx");
        this.m_nPickerInsetPx = n;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getPickerInsetColor() {
        return this.m_sPickerInsetColor;
    }

    @Nonnull
    public ColorPickerOptions setPickerInsetColor(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PickerInsetColor");
        this.m_sPickerInsetColor = string;
        return this;
    }

    @Nonnegative
    public int getPickerZIndex() {
        return this.m_nPickerZIndex;
    }

    @Nonnull
    public ColorPickerOptions setPickerZIndex(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"PickerZIndex");
        this.m_nPickerZIndex = n;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getJSOptions() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (!this.m_bRequired) {
            jSAssocArray.add("required", this.m_bRequired);
        }
        if (!this.m_bAdjust) {
            jSAssocArray.add("adjust", this.m_bAdjust);
        }
        if (this.m_bHash) {
            jSAssocArray.add("hash", this.m_bHash);
        }
        if (!this.m_bCaps) {
            jSAssocArray.add("caps", this.m_bCaps);
        }
        if (!this.m_bSlider) {
            jSAssocArray.add("slider", this.m_bSlider);
        }
        if (!DEFAULT_VALUE_ELEMENT.equals(this.m_sValueElement)) {
            jSAssocArray.add("valueElement", this.m_sValueElement);
        }
        if (!DEFAULT_STYLE_ELEMENT.equals(this.m_sStyleElement)) {
            jSAssocArray.add("styleElement", this.m_sStyleElement);
        }
        if (this.m_aOnImmediateChange != null) {
            jSAssocArray.add("onImmediateChange", (IJSExpression)this.m_aOnImmediateChange);
        }
        if (!this.m_bPickerOnFocus) {
            jSAssocArray.add("pickerOnfocus", this.m_bPickerOnFocus);
        }
        if (!this.m_ePickerMode.equals((Object)DEFAULT_PICKER_MODE)) {
            jSAssocArray.add("pickerMode", this.m_ePickerMode.getAttrValue());
        }
        if (!this.m_ePickerPosition.equals((Object)DEFAULT_PICKER_POSITION)) {
            jSAssocArray.add("pickerPosition", this.m_ePickerPosition.getAttrValue());
        }
        if (!this.m_bPickerSmartPosition) {
            jSAssocArray.add("pickerSmartPosition", this.m_bPickerSmartPosition);
        }
        if (this.m_nPickerButtonHeight != 20) {
            jSAssocArray.add("pickerButtonHeight", this.m_nPickerButtonHeight);
        }
        if (this.m_bPickerClosable) {
            jSAssocArray.add("pickerClosable", this.m_bPickerClosable);
        }
        if (!DEFAULT_PICKER_CLOSE_TEXT.equals(this.m_sPickerCloseText)) {
            jSAssocArray.add("pickerCloseText", this.m_sPickerCloseText);
        }
        if (!DEFAULT_PICKER_BUTTON_COLOR.equals(this.m_sPickerButtonColor)) {
            jSAssocArray.add("pickerButtonColor", this.m_sPickerButtonColor);
        }
        if (this.m_nPickerFacePx != 10) {
            jSAssocArray.add("pickerFace", this.m_nPickerFacePx);
        }
        if (!DEFAULT_PICKER_FACE_COLOR.equals(this.m_sPickerFaceColor)) {
            jSAssocArray.add("pickerFaceColor", this.m_sPickerFaceColor);
        }
        if (this.m_nPickerBorderPx != 1) {
            jSAssocArray.add("pickerBorder", this.m_nPickerBorderPx);
        }
        if (!DEFAULT_PICKER_BORDER_COLOR.equals(this.m_sPickerBorderColor)) {
            jSAssocArray.add("pickerBorderColor", this.m_sPickerBorderColor);
        }
        if (this.m_nPickerInsetPx != 1) {
            jSAssocArray.add("pickerInset", this.m_nPickerInsetPx);
        }
        if (!DEFAULT_PICKER_INSET_COLOR.equals(this.m_sPickerInsetColor)) {
            jSAssocArray.add("pickerInsetColor", this.m_sPickerInsetColor);
        }
        if (this.m_nPickerZIndex != 10000) {
            jSAssocArray.add("pickerZIndex", this.m_nPickerZIndex);
        }
        return jSAssocArray;
    }
}

