/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.colorbox;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.colorbox.EColorBoxText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class ColorBoxOptions {
    public static final boolean DEFAULT_PHOTO = false;
    private Locale m_aDisplayLocale;
    private boolean m_bPhoto = false;
    private String m_sMaxWidth;
    private String m_sMaxHeight;

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Nonnull
    public ColorBoxOptions setDisplayLocale(@Nonnull Locale locale) {
        this.m_aDisplayLocale = locale;
        return this;
    }

    public boolean isPhoto() {
        return this.m_bPhoto;
    }

    @Nonnull
    public ColorBoxOptions setPhoto(boolean bl) {
        this.m_bPhoto = bl;
        return this;
    }

    @Nullable
    public String getMaxWidth() {
        return this.m_sMaxWidth;
    }

    @Nonnull
    public ColorBoxOptions setMaxWidth(@Nullable String string) {
        this.m_sMaxWidth = string;
        return this;
    }

    @Nullable
    public String getMaxHeight() {
        return this.m_sMaxHeight;
    }

    @Nonnull
    public ColorBoxOptions setMaxHeight(@Nullable String string) {
        this.m_sMaxHeight = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getJSOptions() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_bPhoto) {
            jSAssocArray.add("photo", this.m_bPhoto);
        }
        if (StringHelper.isNotEmpty((String)this.m_sMaxWidth)) {
            jSAssocArray.add("maxWidth", this.m_sMaxWidth);
        }
        if (StringHelper.isNotEmpty((String)this.m_sMaxHeight)) {
            jSAssocArray.add("maxHeight", this.m_sMaxHeight);
        }
        if (this.m_aDisplayLocale != null) {
            jSAssocArray.add("current", EColorBoxText.CURRENT.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("previous", EColorBoxText.PREVIOUS.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("next", EColorBoxText.NEXT.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("close", EColorBoxText.CLOSE.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("xhrError", EColorBoxText.XHR_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("imgError", EColorBoxText.IMG_ERROR.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("slideshowStart", EColorBoxText.SLIDESHOW_START.getDisplayText(this.m_aDisplayLocale));
            jSAssocArray.add("slideshowStop", EColorBoxText.SLIDESHOW_STOP.getDisplayText(this.m_aDisplayLocale));
        }
        return jSAssocArray;
    }
}

