/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.chart.v4;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.script.AbstractHCCanvas;
import com.helger.html.hc.html.script.HCScriptInline;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSDefinedClass;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSPackage;
import com.helger.html.jscode.JSRef;
import com.helger.html.jscode.html.JSHtml;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.EUICtrlsJSPathProvider;
import com.helger.photon.uictrls.chart.v4.IChartV4;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCChartV4
extends AbstractHCCanvas<HCChartV4> {
    private final IChartV4 m_aChart;
    private final int m_nID;

    public HCChartV4(@Nonnull IChartV4 iChartV4) {
        this(iChartV4, GlobalIDFactory.getNewIntID());
    }

    public HCChartV4(@Nonnull IChartV4 iChartV4, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)iChartV4, (String)"Chart");
        this.m_aChart = iChartV4;
        this.m_nID = n;
        this.setID(this.getCanvasID());
    }

    @Nonnull
    public IChartV4 getChart() {
        return this.m_aChart;
    }

    public final int getJSID() {
        return this.m_nID;
    }

    @Nonnull
    @Nonempty
    public final String getCanvasID() {
        return "canvas" + this.m_nID;
    }

    @Nonnull
    @Nonempty
    public final String getLegendID() {
        return "legend" + this.m_nID;
    }

    @Nonnull
    @Nonempty
    public final String getJSDataVar() {
        return "data" + this.m_nID;
    }

    @Nonnull
    @Nonempty
    public final String getJSChartVar() {
        return "chart" + this.m_nID;
    }

    @Nonnull
    public JSAssocArray getJSData() {
        return this.m_aChart.getJSData();
    }

    @Nonnull
    public JSAssocArray getJSData(@Nullable IJSExpression iJSExpression) {
        return this.m_aChart.getJSData(iJSExpression);
    }

    @Nonnull
    public JSAssocArray getJSOptions() {
        JSAssocArray jSAssocArray = this.m_aChart.getJSOptions();
        return jSAssocArray;
    }

    @OverrideOnDemand
    protected void onAddInitializationCode(@Nonnull JSPackage jSPackage) {
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        JSPackage jSPackage = new JSPackage();
        JSRef jSRef = JSExpr.ref((String)this.getJSDataVar());
        jSPackage._if((IJSExpression)jSRef)._then().delete((IJSExpression)jSRef);
        JSRef jSRef2 = JSExpr.ref((String)this.getJSChartVar());
        JSBlock jSBlock = jSPackage._if((IJSExpression)jSRef2)._then();
        jSBlock.add((IJSStatement)jSRef2.invoke("destroy"));
        jSBlock.delete((IJSExpression)jSRef2);
        jSRef = jSPackage.variable(this.getCanvasID(), (IJSExpression)JSHtml.documentGetElementById((IHCHasID)this));
        jSRef2 = jSPackage.variable(this.getJSDataVar(), (IJSExpression)this.getJSData());
        jSBlock = this.getJSOptions();
        jSPackage.variable(this.getJSChartVar(), (IJSExpression)((JSInvocation)new JSDefinedClass("Chart")._new().arg((IJSExpression)jSRef)).arg((IJSExpression)new JSAssocArray().add("type", this.m_aChart.getType()).add("data", (IJSExpression)jSRef2).add("options", (IJSExpression)jSBlock)));
        this.onAddInitializationCode(jSPackage);
        this.addChild((IHCNode)new HCScriptInline((IHasJSCode)jSPackage));
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICtrlsJSPathProvider.CHART_4);
    }

    @Nonnull
    public IHasJSCode getJSUpdateCode(@Nonnull IJSExpression iJSExpression) {
        JSPackage jSPackage = new JSPackage();
        jSPackage.invoke((IJSExpression)JSExpr.ref((String)this.getJSChartVar()), "destroy");
        jSPackage.assign((IJSAssignmentTarget)JSExpr.ref((String)this.getJSChartVar()), (IJSExpression)((JSInvocation)new JSDefinedClass("Chart")._new().arg((IJSExpression)JSExpr.ref((String)this.getCanvasID()))).arg((IJSExpression)new JSAssocArray().add("type", this.m_aChart.getType()).add("data", iJSExpression).add("options", (IJSExpression)this.getJSOptions())));
        return jSPackage;
    }
}

