/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.chart.v4;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.chart.v4.AbstractChartDataSet;
import com.helger.photon.uictrls.chart.v4.AbstractChartV4;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public abstract class AbstractChartV4WithLabels<IMPLTYPE extends AbstractChartV4WithLabels<IMPLTYPE, DSTYPE>, DSTYPE extends AbstractChartDataSet<?>>
extends AbstractChartV4<IMPLTYPE> {
    private ICommonsList<String> m_aLabels;
    private final ICommonsList<DSTYPE> m_aDataSets = new CommonsArrayList();

    public AbstractChartV4WithLabels(@Nonnull @Nonempty String string) {
        super(string);
    }

    public boolean hasLabels() {
        return CollectionHelper.isNotEmpty(this.m_aLabels);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllLabels() {
        return new CommonsArrayList(this.m_aLabels);
    }

    @Nonnull
    public IMPLTYPE setLabels(String ... stringArray) {
        this.m_aLabels = new CommonsArrayList((Object[])stringArray);
        return (IMPLTYPE)((AbstractChartV4WithLabels)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setLabels(@Nullable Iterable<String> iterable) {
        this.m_aLabels = new CommonsArrayList(iterable);
        return (IMPLTYPE)((AbstractChartV4WithLabels)this.thisAsT());
    }

    @Nonnull
    public JSArray getDataLabelsAsArray() {
        JSArray jSArray = new JSArray();
        if (this.m_aLabels != null) {
            jSArray.addAll(this.m_aLabels);
        }
        return jSArray;
    }

    public boolean hasDataSet() {
        return this.m_aDataSets.isNotEmpty();
    }

    @Nonnegative
    public int getDataSetCount() {
        return this.m_aDataSets.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DSTYPE> getAllDataSets() {
        return (ICommonsList)this.m_aDataSets.getClone();
    }

    @Nonnull
    public IMPLTYPE addDataSet(@Nonnull DSTYPE DSTYPE) {
        ValueEnforcer.notNull(DSTYPE, (String)"DataSet");
        this.m_aDataSets.add(DSTYPE);
        return (IMPLTYPE)((AbstractChartV4WithLabels)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableCopy
    public final JSArray getDataDatasetsAsArray() {
        JSArray jSArray = new JSArray();
        for (AbstractChartDataSet abstractChartDataSet : this.m_aDataSets) {
            jSArray.add((IJSExpression)abstractChartDataSet.getJSData());
        }
        return jSArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final JSAssocArray getJSData() {
        return this.getJSData((IJSExpression)this.getDataDatasetsAsArray());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final JSAssocArray getJSData(@Nullable IJSExpression iJSExpression) {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add("labels", (IJSExpression)this.getDataLabelsAsArray());
        jSAssocArray.add("datasets", iJSExpression);
        return jSAssocArray;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @ReturnsMutableCopy
    public JSAssocArray getJSOptions() {
        return super.getJSOptions();
    }
}

