/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.chart.v4;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.mutable.MutableBigDecimal;
import com.helger.base.string.StringHelper;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;

@NotThreadSafe
public class AbstractChartDataSet<IMPLTYPE extends AbstractChartDataSet<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    private String m_sLabel;
    private JSArray m_aData;
    private final ICommonsOrderedMap<String, IJSExpression> m_aCustomProps = new CommonsLinkedHashMap();

    @Nullable
    protected static final IJSExpression _toExpr(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) ? JSExpr.lit((String)string) : null;
    }

    @Nullable
    protected static final JSArray _toExpr(String ... stringArray) {
        return stringArray == null ? null : new JSArray().addAll(stringArray);
    }

    @Nonnull
    public IMPLTYPE setLabel(@Nullable String string) {
        this.m_sLabel = string;
        return (IMPLTYPE)((AbstractChartDataSet)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setData(int ... nArray) {
        this.m_aData = new JSArray().addAll(nArray);
        return (IMPLTYPE)((AbstractChartDataSet)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setData(double ... dArray) {
        this.m_aData = new JSArray().addAll(dArray);
        return (IMPLTYPE)((AbstractChartDataSet)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setData(BigDecimal ... bigDecimalArray) {
        this.m_aData = new JSArray().addAll(bigDecimalArray);
        return (IMPLTYPE)((AbstractChartDataSet)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setData(MutableBigDecimal ... mutableBigDecimalArray) {
        JSArray jSArray = new JSArray();
        if (mutableBigDecimalArray != null) {
            for (MutableBigDecimal mutableBigDecimal : mutableBigDecimalArray) {
                jSArray.add(mutableBigDecimal.getAsBigDecimal());
            }
        }
        this.m_aData = jSArray;
        return (IMPLTYPE)((AbstractChartDataSet)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setCustomProperty(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.setCustomProperty(string, AbstractChartDataSet._toExpr(string2));
    }

    @Nonnull
    public IMPLTYPE setCustomProperty(@Nonnull @Nonempty String string, String ... stringArray) {
        return this.setCustomProperty(string, (IJSExpression)AbstractChartDataSet._toExpr(stringArray));
    }

    @Nonnull
    public IMPLTYPE setCustomProperty(@Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        if (iJSExpression == null) {
            this.m_aCustomProps.remove((Object)string);
        } else {
            this.m_aCustomProps.put((Object)string, (Object)iJSExpression);
        }
        return (IMPLTYPE)((AbstractChartDataSet)this.thisAsT());
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public JSAssocArray getJSData() {
        return this.getJSData((IJSExpression)this.m_aData);
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public JSAssocArray getJSData(@Nullable IJSExpression iJSExpression) {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (StringHelper.isNotEmpty((String)this.m_sLabel)) {
            jSAssocArray.add("label", this.m_sLabel);
        }
        if (iJSExpression != null) {
            jSAssocArray.add("data", iJSExpression);
        }
        if (this.m_aCustomProps.isNotEmpty()) {
            jSAssocArray.addAll(this.m_aCustomProps);
        }
        return jSAssocArray;
    }
}

