/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.chart;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.css.decl.CSSRGB;
import com.helger.css.decl.CSSRGBA;
import jakarta.annotation.Nonnull;

@Immutable
public final class ChartPaletteDefault {
    private static final CSSRGB[] BASE_COLORS;
    private static final CSSRGBA[] COLORS;
    private static final CSSRGBA[] FILL_COLORS;
    private static final CSSRGBA[] HIGHLIGHT_COLORS;

    private ChartPaletteDefault() {
    }

    @Nonnull
    @Nonempty
    public static String getColorString(@Nonnegative int n) {
        return COLORS[n % COLORS.length].getAsString();
    }

    @Nonnull
    @ReturnsMutableCopy
    private static String[] _getAllStrings(@Nonnull CSSRGBA[] cSSRGBAArray, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)cSSRGBAArray, (String)"Src");
        ValueEnforcer.isGT0((int)n, (String)"MaxEntries");
        int n2 = Math.min(cSSRGBAArray.length, n);
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = cSSRGBAArray[i].getAsString();
        }
        return stringArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllColorStrings() {
        return ChartPaletteDefault.getAllColorStrings(COLORS.length);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllColorStrings(@Nonnegative int n) {
        return ChartPaletteDefault._getAllStrings(COLORS, n);
    }

    @Nonnull
    @Nonempty
    public static String getFillColorString(@Nonnegative int n) {
        return FILL_COLORS[n % FILL_COLORS.length].getAsString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllFillColorStrings() {
        return ChartPaletteDefault.getAllFillColorStrings(FILL_COLORS.length);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllFillColorStrings(@Nonnegative int n) {
        return ChartPaletteDefault._getAllStrings(FILL_COLORS, n);
    }

    @Nonnull
    @Nonempty
    public static String getHighlightColorString(@Nonnegative int n) {
        return HIGHLIGHT_COLORS[n % HIGHLIGHT_COLORS.length].getAsString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllHighlightColorStrings() {
        return ChartPaletteDefault.getAllHighlightColorStrings(HIGHLIGHT_COLORS.length);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllHighlightColorStrings(@Nonnegative int n) {
        return ChartPaletteDefault._getAllStrings(HIGHLIGHT_COLORS, n);
    }

    static {
        int n;
        BASE_COLORS = new CSSRGB[]{new CSSRGB(51, 102, 204), new CSSRGB(153, 204, 255), new CSSRGB(153, 153, 51), new CSSRGB(102, 102, 153), new CSSRGB(204, 153, 51), new CSSRGB(0, 102, 102), new CSSRGB(51, 153, 255), new CSSRGB(153, 51, 0), new CSSRGB(204, 204, 153), new CSSRGB(102, 102, 102), new CSSRGB(255, 204, 102), new CSSRGB(102, 153, 204), new CSSRGB(102, 51, 102), new CSSRGB(153, 153, 204), new CSSRGB(204, 204, 204), new CSSRGB(102, 153, 153), new CSSRGB(204, 204, 102), new CSSRGB(204, 102, 0), new CSSRGB(153, 153, 255), new CSSRGB(0, 102, 204), new CSSRGB(153, 204, 204), new CSSRGB(153, 153, 153), new CSSRGB(255, 204, 0), new CSSRGB(0, 153, 153), new CSSRGB(153, 204, 51), new CSSRGB(255, 153, 0), new CSSRGB(153, 153, 102), new CSSRGB(102, 204, 204), new CSSRGB(51, 153, 102), new CSSRGB(204, 204, 51)};
        COLORS = new CSSRGBA[BASE_COLORS.length];
        FILL_COLORS = new CSSRGBA[BASE_COLORS.length];
        HIGHLIGHT_COLORS = new CSSRGBA[BASE_COLORS.length];
        for (n = 0; n < COLORS.length; ++n) {
            ChartPaletteDefault.COLORS[n] = new CSSRGBA(BASE_COLORS[n], "0.8");
        }
        for (n = 0; n < FILL_COLORS.length; ++n) {
            ChartPaletteDefault.FILL_COLORS[n] = new CSSRGBA(BASE_COLORS[n], "0.2");
        }
        for (n = 0; n < HIGHLIGHT_COLORS.length; ++n) {
            ChartPaletteDefault.HIGHLIGHT_COLORS[n] = new CSSRGBA(BASE_COLORS[n], "1");
        }
    }
}

