/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.bloodhound;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jquery.JQueryAjaxBuilder;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.photon.uictrls.bloodhound.EBloodhoundRemoteRateLimitBy;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class BloodhoundRemote
implements ICloneable<BloodhoundRemote> {
    public static final String JSON_URL = "url";
    public static final String JSON_WILDCARD = "wildcard";
    public static final String JSON_REPLACE = "replace";
    public static final String JSON_RATE_LIMIT_BY = "rateLimitBy";
    public static final String JSON_RATE_LIMIT_WAIT = "rateLimitWait";
    public static final String JSON_FILTER = "filter";
    public static final String JSON_AJAX = "ajax";
    public static final String DEFAULT_WILDCARD = "_query_";
    public static final EBloodhoundRemoteRateLimitBy DEFAULT_RATE_LIMIT_BY = EBloodhoundRemoteRateLimitBy.DEBOUNCE;
    public static final int DEFAULT_RATE_LIMIT_WAIT = 300;
    private final SimpleURL m_aURL;
    private String m_sWildcard;
    private IJSExpression m_aReplace;
    private EBloodhoundRemoteRateLimitBy m_eRateLimitBy;
    private int m_nRateLimitWait = 300;
    private IJSExpression m_aFilter;
    private JQueryAjaxBuilder m_aAjax;

    public BloodhoundRemote(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        this.m_aURL = new SimpleURL((IURLData)iSimpleURL);
    }

    public BloodhoundRemote(@Nonnull BloodhoundRemote bloodhoundRemote) {
        ValueEnforcer.notNull((Object)bloodhoundRemote, (String)"Other");
        this.m_aURL = bloodhoundRemote.m_aURL.getClone();
        this.m_sWildcard = bloodhoundRemote.m_sWildcard;
        this.m_aReplace = bloodhoundRemote.m_aReplace;
        this.m_eRateLimitBy = bloodhoundRemote.m_eRateLimitBy;
        this.m_nRateLimitWait = bloodhoundRemote.m_nRateLimitWait;
        this.m_aFilter = bloodhoundRemote.m_aFilter;
        this.m_aAjax = bloodhoundRemote.m_aAjax;
    }

    @Nonnull
    public ISimpleURL getURL() {
        return this.m_aURL;
    }

    @Nullable
    public String getWildcard() {
        return this.m_sWildcard;
    }

    @Nonnull
    public BloodhoundRemote setWildcard(@Nullable String string) {
        this.m_sWildcard = string;
        return this;
    }

    @Nullable
    public IJSExpression getReplace() {
        return this.m_aReplace;
    }

    @Nonnull
    public BloodhoundRemote setReplace(@Nullable IJSExpression iJSExpression) {
        this.m_aReplace = iJSExpression;
        return this;
    }

    @Nonnull
    public EBloodhoundRemoteRateLimitBy getRateLimitBy() {
        return this.m_eRateLimitBy;
    }

    @Nonnull
    public BloodhoundRemote setRateLimitBy(@Nonnull EBloodhoundRemoteRateLimitBy eBloodhoundRemoteRateLimitBy) {
        this.m_eRateLimitBy = (EBloodhoundRemoteRateLimitBy)((Object)ValueEnforcer.notNull((Object)((Object)eBloodhoundRemoteRateLimitBy), (String)"RateLimitBy"));
        return this;
    }

    @Nonnegative
    public int getRateLimitWait() {
        return this.m_nRateLimitWait;
    }

    @Nonnull
    public BloodhoundRemote setRateLimitWait(@Nonnegative int n) {
        this.m_nRateLimitWait = ValueEnforcer.isGT0((int)n, (String)"RateLimitWait");
        return this;
    }

    @Nullable
    public IJSExpression getFilter() {
        return this.m_aFilter;
    }

    @Nonnull
    public BloodhoundRemote setFilter(@Nullable IJSExpression iJSExpression) {
        this.m_aFilter = iJSExpression;
        return this;
    }

    @Nullable
    public JQueryAjaxBuilder getAjax() {
        return this.m_aAjax;
    }

    @Nonnull
    public BloodhoundRemote setAjax(@Nullable JQueryAjaxBuilder jQueryAjaxBuilder) {
        this.m_aAjax = jQueryAjaxBuilder;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add(JSON_URL, this.m_aURL.getAsString());
        if (StringHelper.isNotEmpty((String)this.m_sWildcard)) {
            jSAssocArray.add(JSON_WILDCARD, this.m_sWildcard);
        }
        if (this.m_aReplace != null) {
            jSAssocArray.add(JSON_REPLACE, this.m_aReplace);
        }
        if (this.m_eRateLimitBy != null) {
            jSAssocArray.add(JSON_RATE_LIMIT_BY, this.m_eRateLimitBy.getValue());
        }
        if (this.m_nRateLimitWait != 300) {
            jSAssocArray.add(JSON_RATE_LIMIT_WAIT, this.m_nRateLimitWait);
        }
        if (this.m_aFilter != null) {
            jSAssocArray.add(JSON_FILTER, this.m_aFilter);
        }
        if (this.m_aAjax != null) {
            jSAssocArray.add(JSON_AJAX, (IJSExpression)this.m_aAjax.getJSSettings());
        }
        return jSAssocArray;
    }

    @Nonnull
    public BloodhoundRemote getClone() {
        return new BloodhoundRemote(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URL", (Object)this.m_aURL).appendIfNotNull(JSON_WILDCARD, (Object)this.m_sWildcard).appendIfNotNull(JSON_REPLACE, (Object)this.m_aReplace).appendIfNotNull(JSON_RATE_LIMIT_BY, (Object)this.m_eRateLimitBy).append(JSON_RATE_LIMIT_WAIT, this.m_nRateLimitWait).appendIfNotNull(JSON_FILTER, (Object)this.m_aFilter).appendIfNotNull(JSON_AJAX, (Object)this.m_aAjax).getToString();
    }
}

