/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.bloodhound;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jquery.JQueryAjaxBuilder;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class BloodhoundPrefetch
implements ICloneable<BloodhoundPrefetch> {
    public static final String JSON_URL = "url";
    public static final String JSON_CACHE_KEY = "cacheKey";
    public static final String JSON_TTL = "ttl";
    public static final String JSON_THUMBPRINT = "thumbprint";
    public static final String JSON_FILTER = "filter";
    public static final String JSON_AJAX = "ajax";
    public static final long DEFAULT_TTL = 86400000L;
    private final SimpleURL m_aURL;
    private String m_sCacheKey;
    private long m_nTTL = 86400000L;
    private String m_sThumbprint;
    private IJSExpression m_aFilter;
    private JQueryAjaxBuilder m_aAjax;

    public BloodhoundPrefetch(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        this.m_aURL = new SimpleURL((IURLData)iSimpleURL);
    }

    public BloodhoundPrefetch(@Nonnull BloodhoundPrefetch bloodhoundPrefetch) {
        ValueEnforcer.notNull((Object)bloodhoundPrefetch, (String)"Other");
        this.m_aURL = bloodhoundPrefetch.m_aURL.getClone();
        this.m_sCacheKey = bloodhoundPrefetch.m_sCacheKey;
        this.m_nTTL = bloodhoundPrefetch.m_nTTL;
        this.m_sThumbprint = bloodhoundPrefetch.m_sThumbprint;
        this.m_aFilter = bloodhoundPrefetch.m_aFilter;
        this.m_aAjax = bloodhoundPrefetch.m_aAjax;
    }

    @Nonnull
    public ISimpleURL getURL() {
        return this.m_aURL;
    }

    @Nullable
    public String getCacheKey() {
        return this.m_sCacheKey;
    }

    @Nonnull
    public BloodhoundPrefetch setCacheKey(@Nullable String string) {
        this.m_sCacheKey = string;
        return this;
    }

    @Nonnegative
    public long getTTL() {
        return this.m_nTTL;
    }

    @Nonnull
    public BloodhoundPrefetch setTTL(@Nonnegative long l) {
        this.m_nTTL = ValueEnforcer.isGT0((long)l, (String)"TTL");
        return this;
    }

    @Nullable
    public String getThumbprint() {
        return this.m_sThumbprint;
    }

    @Nonnull
    public BloodhoundPrefetch setThumbprint(@Nullable String string) {
        this.m_sThumbprint = string;
        return this;
    }

    @Nullable
    public IJSExpression getFilter() {
        return this.m_aFilter;
    }

    @Nonnull
    public BloodhoundPrefetch setFilter(@Nullable IJSExpression iJSExpression) {
        this.m_aFilter = iJSExpression;
        return this;
    }

    @Nullable
    public JQueryAjaxBuilder getAjax() {
        return this.m_aAjax;
    }

    @Nonnull
    public BloodhoundPrefetch setAjax(@Nullable JQueryAjaxBuilder jQueryAjaxBuilder) {
        this.m_aAjax = jQueryAjaxBuilder;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add(JSON_URL, this.m_aURL.getAsString());
        if (StringHelper.isNotEmpty((String)this.m_sCacheKey)) {
            jSAssocArray.add(JSON_CACHE_KEY, this.m_sCacheKey);
        }
        if (this.m_nTTL != 86400000L) {
            jSAssocArray.add(JSON_TTL, this.m_nTTL);
        }
        if (StringHelper.isNotEmpty((String)this.m_sThumbprint)) {
            jSAssocArray.add(JSON_THUMBPRINT, this.m_sThumbprint);
        }
        if (this.m_aFilter != null) {
            jSAssocArray.add(JSON_FILTER, this.m_aFilter);
        }
        if (this.m_aAjax != null) {
            jSAssocArray.add(JSON_AJAX, (IJSExpression)this.m_aAjax.getJSSettings());
        }
        return jSAssocArray;
    }

    @Nonnull
    public BloodhoundPrefetch getClone() {
        return new BloodhoundPrefetch(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URL", (Object)this.m_aURL).appendIfNotNull(JSON_CACHE_KEY, (Object)this.m_sCacheKey).append(JSON_TTL, this.m_nTTL).appendIfNotNull("thumbPrint", (Object)this.m_sThumbprint).appendIfNotNull(JSON_FILTER, (Object)this.m_aFilter).appendIfNotNull(JSON_AJAX, (Object)this.m_aAjax).getToString();
    }
}

