/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.bloodhound;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSFieldRef;
import com.helger.html.jscode.JSParam;
import com.helger.html.jscode.JSReturn;
import com.helger.json.IJson;
import com.helger.photon.uictrls.bloodhound.BloodhoundDatum;
import com.helger.photon.uictrls.bloodhound.BloodhoundJS;
import com.helger.photon.uictrls.bloodhound.BloodhoundPrefetch;
import com.helger.photon.uictrls.bloodhound.BloodhoundRemote;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BloodhoundOptions
implements ICloneable<BloodhoundOptions> {
    public static final String JSON_DATUM_TOKENIZER = "datumTokenizer";
    public static final String JSON_QUERY_TOKENIZER = "queryTokenizer";
    public static final String JSON_LIMIT = "limit";
    public static final String JSON_DUP_DETECTOR = "dupDetector";
    public static final String JSON_SORTER = "sorter";
    public static final String JSON_LOCAL = "local";
    public static final String JSON_PREFETCH = "prefetch";
    public static final String JSON_REMOTE = "remote";
    public static final int DEFAULT_LIMIT = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(BloodhoundOptions.class);
    private IJSExpression m_aDatumTokenizer;
    private IJSExpression m_aQueryTokenizer;
    private int m_nLimit = 5;
    private IJSExpression m_aDupDetector;
    private IJSExpression m_aSorter;
    private ICommonsList<? extends BloodhoundDatum> m_aLocal;
    private BloodhoundPrefetch m_aPrefetch;
    private BloodhoundRemote m_aRemote;

    public BloodhoundOptions() {
    }

    public BloodhoundOptions(@Nonnull BloodhoundOptions bloodhoundOptions) {
        ValueEnforcer.notNull((Object)bloodhoundOptions, (String)"Other");
        this.m_aDatumTokenizer = bloodhoundOptions.m_aDatumTokenizer;
        this.m_aQueryTokenizer = bloodhoundOptions.m_aQueryTokenizer;
        this.m_nLimit = bloodhoundOptions.m_nLimit;
        this.m_aDupDetector = bloodhoundOptions.m_aDupDetector;
        this.m_aSorter = bloodhoundOptions.m_aSorter;
        this.m_aLocal = bloodhoundOptions.m_aLocal == null ? null : (ICommonsList)bloodhoundOptions.m_aLocal.getClone();
        this.m_aPrefetch = bloodhoundOptions.m_aPrefetch == null ? null : bloodhoundOptions.m_aPrefetch.getClone();
        this.m_aRemote = bloodhoundOptions.m_aRemote == null ? null : bloodhoundOptions.m_aRemote.getClone();
    }

    @Nullable
    public IJSExpression getDatumTokenizer() {
        return this.m_aDatumTokenizer;
    }

    @Nonnull
    public BloodhoundOptions setDatumTokenizer(@Nullable IJSExpression iJSExpression) {
        this.m_aDatumTokenizer = iJSExpression;
        return this;
    }

    @Nonnull
    private BloodhoundOptions _setSpecialDatumTokenizer(@Nonnull JSFieldRef jSFieldRef, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DatumValueFieldName");
        JSParam jSParam = new JSParam("d");
        return this.setDatumTokenizer((IJSExpression)new JSAnonymousFunction(jSParam, (IJSStatement)jSFieldRef.invoke().arg((IJSExpression)jSParam.ref(string))));
    }

    @Nonnull
    public BloodhoundOptions setDatumTokenizerNonword(@Nonnull @Nonempty String string) {
        return this._setSpecialDatumTokenizer(BloodhoundJS.bloodhoundTokenizersNonword(), string);
    }

    @Nonnull
    public BloodhoundOptions setDatumTokenizerWhitespace(@Nonnull @Nonempty String string) {
        return this._setSpecialDatumTokenizer(BloodhoundJS.bloodhoundTokenizersWhitespace(), string);
    }

    @Nonnull
    public BloodhoundOptions setDatumTokenizerPreTokenized() {
        JSParam jSParam = new JSParam("d");
        return this.setDatumTokenizer((IJSExpression)new JSAnonymousFunction(jSParam, (IJSStatement)new JSReturn((IJSExpression)jSParam.ref("tokens"))));
    }

    @Nullable
    public IJSExpression getQueryTokenizer() {
        return this.m_aQueryTokenizer;
    }

    @Nonnull
    public BloodhoundOptions setQueryTokenizer(@Nullable IJSExpression iJSExpression) {
        this.m_aQueryTokenizer = iJSExpression;
        return this;
    }

    @Nonnull
    public BloodhoundOptions setQueryTokenizerNonword() {
        return this.setQueryTokenizer((IJSExpression)BloodhoundJS.bloodhoundTokenizersNonword());
    }

    @Nonnull
    public BloodhoundOptions setQueryTokenizerWhitespace() {
        return this.setQueryTokenizer((IJSExpression)BloodhoundJS.bloodhoundTokenizersWhitespace());
    }

    @Nonnegative
    public int getLimit() {
        return this.m_nLimit;
    }

    @Nonnull
    public BloodhoundOptions setLimit(@Nonnegative int n) {
        this.m_nLimit = ValueEnforcer.isGT0((int)n, (String)"Limit");
        return this;
    }

    @Nullable
    public IJSExpression getDupDetector() {
        return this.m_aDupDetector;
    }

    @Nonnull
    public BloodhoundOptions setDupDetector(@Nullable IJSExpression iJSExpression) {
        this.m_aDupDetector = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression getSorter() {
        return this.m_aSorter;
    }

    @Nonnull
    public BloodhoundOptions setSorter(@Nullable IJSExpression iJSExpression) {
        this.m_aSorter = iJSExpression;
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<? extends BloodhoundDatum> getLocal() {
        return this.m_aLocal == null ? null : (ICommonsList)this.m_aLocal.getClone();
    }

    @Nonnull
    public BloodhoundOptions setLocal(BloodhoundDatum ... bloodhoundDatumArray) {
        return this.setLocal((List<? extends BloodhoundDatum>)(bloodhoundDatumArray == null ? null : new CommonsArrayList((Object[])bloodhoundDatumArray)));
    }

    @Nonnull
    public BloodhoundOptions setLocal(@Nullable List<? extends BloodhoundDatum> list) {
        this.m_aLocal = list == null ? null : new CommonsArrayList(list);
        return this;
    }

    @Nullable
    public BloodhoundPrefetch getPrefetch() {
        return this.m_aPrefetch;
    }

    @Nonnull
    public BloodhoundOptions setPrefetch(@Nullable BloodhoundPrefetch bloodhoundPrefetch) {
        this.m_aPrefetch = bloodhoundPrefetch;
        return this;
    }

    @Nullable
    public BloodhoundRemote getRemote() {
        return this.m_aRemote;
    }

    @Nonnull
    public BloodhoundOptions setRemote(@Nullable BloodhoundRemote bloodhoundRemote) {
        this.m_aRemote = bloodhoundRemote;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSObject() {
        if (this.m_aDatumTokenizer == null) {
            LOGGER.warn("No datumTokenizer present!");
        }
        if (this.m_aQueryTokenizer == null) {
            LOGGER.warn("No queryTokenizer present!");
        }
        if (this.m_aLocal == null && this.m_aPrefetch == null && this.m_aRemote == null) {
            LOGGER.warn("Either local, prefetch or remote must be set!");
        }
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aDatumTokenizer != null) {
            jSAssocArray.add(JSON_DATUM_TOKENIZER, this.m_aDatumTokenizer);
        }
        if (this.m_aQueryTokenizer != null) {
            jSAssocArray.add(JSON_QUERY_TOKENIZER, this.m_aQueryTokenizer);
        }
        if (this.m_nLimit != 5) {
            jSAssocArray.add(JSON_LIMIT, this.m_nLimit);
        }
        if (this.m_aDupDetector != null) {
            jSAssocArray.add(JSON_DUP_DETECTOR, this.m_aDupDetector);
        }
        if (this.m_aSorter != null) {
            jSAssocArray.add(JSON_SORTER, this.m_aSorter);
        }
        if (this.m_aLocal != null) {
            JSArray jSArray = new JSArray();
            for (BloodhoundDatum bloodhoundDatum : this.m_aLocal) {
                jSArray.add((IJson)bloodhoundDatum.getAsJson());
            }
            jSAssocArray.add(JSON_LOCAL, (IJSExpression)jSArray);
        }
        if (this.m_aPrefetch != null) {
            jSAssocArray.add(JSON_PREFETCH, (IJSExpression)this.m_aPrefetch.getAsJSObject());
        }
        if (this.m_aRemote != null) {
            jSAssocArray.add(JSON_REMOTE, (IJSExpression)this.m_aRemote.getAsJSObject());
        }
        return jSAssocArray;
    }

    @Nonnull
    public BloodhoundOptions getClone() {
        return new BloodhoundOptions(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull(JSON_DATUM_TOKENIZER, (Object)this.m_aDatumTokenizer).appendIfNotNull(JSON_QUERY_TOKENIZER, (Object)this.m_aQueryTokenizer).append(JSON_LIMIT, this.m_nLimit).appendIfNotNull(JSON_DUP_DETECTOR, (Object)this.m_aDupDetector).appendIfNotNull(JSON_SORTER, (Object)this.m_aSorter).appendIfNotNull(JSON_LOCAL, this.m_aLocal).appendIfNotNull(JSON_PREFETCH, (Object)this.m_aPrefetch).appendIfNotNull(JSON_REMOTE, (Object)this.m_aRemote).getToString();
    }
}

