/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.bloodhound;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IAddableByTrait;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.json.IHasJson;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import jakarta.annotation.Nonnull;
import java.util.Collection;

@Immutable
public class BloodhoundDatum
implements IHasJson,
Comparable<BloodhoundDatum> {
    public static final String JSON_VALUE = "value";
    public static final String JSON_TOKENS = "tokens";
    private final String m_sValue;
    private final ICommonsList<String> m_aTokens;

    public BloodhoundDatum(@Nonnull String string) {
        this(string, BloodhoundDatum.getTokensFromValue(string));
    }

    public BloodhoundDatum(@Nonnull String string, String ... stringArray) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        ValueEnforcer.notEmpty((Object[])stringArray, (String)"Tokens");
        this.m_sValue = string;
        this.m_aTokens = new CommonsArrayList((Object[])stringArray);
    }

    public BloodhoundDatum(@Nonnull String string, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        ValueEnforcer.notEmpty(collection, (String)"Tokens");
        this.m_sValue = string;
        this.m_aTokens = new CommonsArrayList(collection);
    }

    @Nonnull
    public final String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllTokens() {
        return (ICommonsList)this.m_aTokens.getClone();
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @ReturnsMutableCopy
    @OverrideOnDemand
    public IJsonObject getAsJson() {
        return (IJsonObject)((IJsonObject)new JsonObject().add((Object)JSON_VALUE, (Object)this.m_sValue)).add((Object)JSON_TOKENS, (IAddableByTrait)((IJson)new JsonArray().addAll(this.m_aTokens)));
    }

    @Override
    public int compareTo(@Nonnull BloodhoundDatum bloodhoundDatum) {
        return this.m_sValue.compareTo(bloodhoundDatum.m_sValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BloodhoundDatum bloodhoundDatum = (BloodhoundDatum)object;
        return this.m_sValue.equals(bloodhoundDatum.m_sValue) && this.m_aTokens.equals(bloodhoundDatum.m_aTokens);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).append(this.m_aTokens).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append(JSON_VALUE, (Object)this.m_sValue).append(JSON_TOKENS, this.m_aTokens).getToString();
    }

    @Nonnull
    public static String[] getTokensFromValue(@Nonnull String string) {
        return RegExHelper.getSplitToArray((CharSequence)StringHelper.trim((String)string), (String)"\\W+");
    }
}

