/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.autonumeric;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCInput;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.jquery.JQuery;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSGlobal;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.html.IHCNodeWithJSOptions;
import com.helger.html.request.IHCRequestField;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.EUICtrlsCSSPathProvider;
import com.helger.photon.uictrls.EUICtrlsJSPathProvider;
import com.helger.photon.uictrls.autonumeric.EAutoNumericLeadingZero;
import com.helger.photon.uictrls.autonumeric.EAutoNumericRoundingMode;
import com.helger.photon.uictrls.autonumeric.HCAutoNumericJS;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

@NotThreadSafe
public abstract class AbstractHCAutoNumeric<IMPLTYPE extends AbstractHCAutoNumeric<IMPLTYPE>>
extends AbstractHCInput<IMPLTYPE>
implements IHCNodeWithJSOptions {
    public static final ICSSClassProvider CSS_CLASS_AUTO_NUMERIC_EDIT = DefaultCSSClassProvider.create((String)"auto-numeric-edit");
    public static final int DEFAULT_MIN_VALUE = -999999999;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sDefaultThousandSeparator = null;
    private String m_sThousandSeparator;
    private String m_sDecimalSeparator;
    private Integer m_aDecimalPlaces;
    private BigDecimal m_aMin;
    private BigDecimal m_aMax;
    private EAutoNumericLeadingZero m_eLeadingZero;
    private EAutoNumericRoundingMode m_eRoundingMode;

    public AbstractHCAutoNumeric(@Nullable IHCRequestField iHCRequestField, @Nonnull Locale locale) {
        super(EHCInputType.TEXT);
        if (iHCRequestField != null) {
            this.setName(iHCRequestField.getFieldName());
            this.setValue(iHCRequestField.getRequestValue());
        }
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.ensureID();
        this.addClass(CSS_CLASS_AUTO_NUMERIC_EDIT);
        this.m_aMin = BigDecimal.valueOf(-999999999L);
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        this.m_sThousandSeparator = Character.toString(decimalFormatSymbols.getGroupingSeparator());
        this.m_sDecimalSeparator = Character.toString(decimalFormatSymbols.getDecimalSeparator());
        String string = AbstractHCAutoNumeric.getDefaultThousandSeparator();
        if (string != null) {
            this.m_sThousandSeparator = string;
        }
    }

    @Nullable
    public static String getDefaultThousandSeparator() {
        return (String)RW_LOCK.readLockedGet(() -> s_sDefaultThousandSeparator);
    }

    public static void setDefaultThousandSeparator(@Nullable String string) {
        RW_LOCK.writeLocked(() -> {
            s_sDefaultThousandSeparator = string;
        });
    }

    @Nullable
    public String getThousandSeparator() {
        return this.m_sThousandSeparator;
    }

    @Nonnull
    public IMPLTYPE setThousandSeparator(@Nullable String string) {
        this.m_sThousandSeparator = string;
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    @Nullable
    public String getDecimalSeparator() {
        return this.m_sDecimalSeparator;
    }

    @Nonnull
    public IMPLTYPE setDecimalSeparator(@Nullable String string) {
        this.m_sDecimalSeparator = string;
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    @Nullable
    public Integer getDecimalPlaces() {
        return this.m_aDecimalPlaces;
    }

    @Nonnull
    public IMPLTYPE setDecimalPlaces(int n) {
        this.m_aDecimalPlaces = n;
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    private void _checkMinMax() {
        if (this.m_aMin != null && this.m_aMax != null && this.m_aMin.compareTo(this.m_aMax) > 0) {
            throw new IllegalArgumentException("Min (" + String.valueOf(this.m_aMin) + ") must be <= max (" + String.valueOf(this.m_aMax) + ")!");
        }
    }

    @Nullable
    public BigDecimal getMin() {
        return this.m_aMin;
    }

    @Nonnull
    public IMPLTYPE setMin(long l) {
        return this.setMin(BigDecimal.valueOf(l));
    }

    @Nonnull
    public IMPLTYPE setMin(double d) {
        return this.setMin(BigDecimal.valueOf(d));
    }

    @Nonnull
    public IMPLTYPE setMin(@Nullable BigDecimal bigDecimal) {
        this.m_aMin = bigDecimal;
        this._checkMinMax();
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    @Nullable
    public BigDecimal getMax() {
        return this.m_aMax;
    }

    @Nonnull
    public IMPLTYPE setMax(long l) {
        return this.setMax(BigDecimal.valueOf(l));
    }

    @Nonnull
    public IMPLTYPE setMax(double d) {
        return this.setMax(BigDecimal.valueOf(d));
    }

    @Nonnull
    public IMPLTYPE setMax(@Nullable BigDecimal bigDecimal) {
        this.m_aMax = bigDecimal;
        this._checkMinMax();
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    @Nullable
    public EAutoNumericLeadingZero getLeadingZero() {
        return this.m_eLeadingZero;
    }

    @Nonnull
    public IMPLTYPE setLeadingZero(@Nullable EAutoNumericLeadingZero eAutoNumericLeadingZero) {
        this.m_eLeadingZero = eAutoNumericLeadingZero;
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    @Nullable
    public EAutoNumericRoundingMode getRoundingMode() {
        return this.m_eRoundingMode;
    }

    @Nonnull
    public IMPLTYPE setRoundingMode(@Nullable EAutoNumericRoundingMode eAutoNumericRoundingMode) {
        this.m_eRoundingMode = eAutoNumericRoundingMode;
        return (IMPLTYPE)((Object)((AbstractHCAutoNumeric)this.thisAsT()));
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull IJSExpression iJSExpression) {
        return iJSExpression.invoke("autoNumeric");
    }

    @Nonnull
    public JSInvocation invoke() {
        return AbstractHCAutoNumeric.invoke((IJSExpression)JQuery.idRef((IHCHasID)this));
    }

    @Nonnull
    public JSInvocation autoNumericInit() {
        return (JSInvocation)this.invoke().arg("init");
    }

    @Nonnull
    public JSInvocation autoNumericInit(@Nonnull JSAssocArray jSAssocArray) {
        return (JSInvocation)this.autoNumericInit().arg((IJSExpression)jSAssocArray);
    }

    @Nonnull
    public JSInvocation autoNumericDestroy() {
        return (JSInvocation)this.invoke().arg("destroy");
    }

    @Nonnull
    public JSInvocation autoNumericUpdate() {
        return (JSInvocation)this.invoke().arg("update");
    }

    @Nonnull
    public JSInvocation autoNumericSet() {
        return (JSInvocation)this.invoke().arg("set");
    }

    @Nonnull
    public JSInvocation autoNumericSet(int n) {
        return (JSInvocation)this.autoNumericSet().arg(n);
    }

    @Nonnull
    public JSInvocation autoNumericSet(@Nonnull BigDecimal bigDecimal) {
        return (JSInvocation)this.autoNumericSet().arg(bigDecimal);
    }

    @Nonnull
    public JSInvocation autoNumericSet(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)this.autoNumericSet().arg(iJSExpression);
    }

    @Nonnull
    public JSInvocation autoNumericGet() {
        return (JSInvocation)this.invoke().arg("get");
    }

    @Nonnull
    public JSInvocation autoNumericGetAsFloat() {
        return JSGlobal.parseFloat((IJSExpression)this.autoNumericGet());
    }

    @Nonnull
    public JSInvocation autoNumericGetString() {
        return (JSInvocation)this.invoke().arg("getString");
    }

    @Nonnull
    public JSInvocation autoNumericGetArray() {
        return (JSInvocation)this.invoke().arg("getArray");
    }

    @Nonnull
    public JSInvocation autoNumericGetSettings() {
        return (JSInvocation)this.invoke().arg("getSettings");
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getJSOptions() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_sThousandSeparator != null) {
            jSAssocArray.add("aSep", this.m_sThousandSeparator);
        }
        if (this.m_sDecimalSeparator != null) {
            jSAssocArray.add("aDec", this.m_sDecimalSeparator);
        }
        if (this.m_aDecimalPlaces != null) {
            jSAssocArray.add("mDec", this.m_aDecimalPlaces.intValue());
        }
        if (this.m_aMin != null) {
            jSAssocArray.add("vMin", this.m_aMin.toString());
        }
        if (this.m_aMax != null) {
            jSAssocArray.add("vMax", this.m_aMax.toString());
        }
        if (this.m_eLeadingZero != null) {
            jSAssocArray.add("lZero", this.m_eLeadingZero.getID());
        }
        if (this.m_eRoundingMode != null) {
            jSAssocArray.add("mRound", this.m_eRoundingMode.getID());
        }
        return jSAssocArray;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        iHCHasChildrenMutable.addChild((IHCNode)new HCAutoNumericJS(this));
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICtrlsCSSPathProvider.AUTONUMERIC);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICtrlsJSPathProvider.AUTONUMERIC);
    }
}

