/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.systemmsg;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.photon.core.systemmsg.ISystemMessageRenderer;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class SystemMessageRendererPlainText
implements ISystemMessageRenderer {
    public static final SystemMessageRendererPlainText INSTANCE = new SystemMessageRendererPlainText();

    protected SystemMessageRendererPlainText() {
    }

    @Nonnull
    public String getDisplayText(@Nonnull Locale locale) {
        return EText.DESCRIPTION.getDisplayText(locale);
    }

    public void renderSystemMessage(@Nonnull @Nonempty String string, IHCElementWithChildren<?> iHCElementWithChildren) {
        iHCElementWithChildren.addChildren((Iterable)HCExtHelper.nl2divList((String)string));
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        DESCRIPTION("Die Nachricht wird ohne Formatierung dargestellt", "The message will be rendered as plain text");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

