/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.serverlog;

import com.helger.base.string.StringHelper;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.photon.uicore.serverlog.ServerLogSessionKey;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxExecutorServerLog
implements IAjaxExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxExecutorServerLog.class);
    private static final IErrorLevel DEFAULT_SEVERITY = EErrorLevel.INFO;
    private static final String PARAM_SEVERITY = "severity";
    private static final String PARAM_MESSAGE = "message";
    private static final String PARAM_KEY = "key";

    @Nonnull
    public static IErrorLevel getErrorLevelFromString(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            if ("fatal".equalsIgnoreCase(string)) {
                return EErrorLevel.FATAL_ERROR;
            }
            if ("error".equalsIgnoreCase(string)) {
                return EErrorLevel.ERROR;
            }
            if ("warn".equalsIgnoreCase(string) || "warning".equalsIgnoreCase(string)) {
                return EErrorLevel.WARN;
            }
            if ("info".equalsIgnoreCase(string)) {
                return EErrorLevel.INFO;
            }
            if ("success".equalsIgnoreCase(string) || "debug".equalsIgnoreCase(string) || "trace".equalsIgnoreCase(string)) {
                return EErrorLevel.SUCCESS;
            }
        }
        return DEFAULT_SEVERITY;
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        String string = iRequestWebScopeWithoutResponse.params().getAsString((Object)PARAM_SEVERITY);
        String string2 = iRequestWebScopeWithoutResponse.params().getAsString((Object)PARAM_MESSAGE);
        String string3 = iRequestWebScopeWithoutResponse.params().getAsString((Object)PARAM_KEY);
        String string4 = ServerLogSessionKey.getGeneratedSessionKey();
        if (StringHelper.isEmpty((String)string2) || string4 == null || !string4.equals(string3)) {
            LOGGER.error("Missing required parameter");
            photonUnifiedResponse.createBadRequest();
            return;
        }
        IErrorLevel iErrorLevel = AjaxExecutorServerLog.getErrorLevelFromString(string);
        LogHelper.log(AjaxExecutorServerLog.class, (IErrorLevel)iErrorLevel, (String)string2);
        photonUnifiedResponse.jsonEmpty();
    }
}

