/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.system;

import com.helger.annotation.misc.Translatable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.sections.HCH1;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.uicore.page.AbstractWebPage;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPageNotFound<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPage<WPECTYPE> {
    public static final String PAGEID_SYSTEM_NOTFOUND = "system.notfound";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPageNotFound.class);

    public SystemPageNotFound() {
        super(PAGEID_SYSTEM_NOTFOUND, ETextBase.PAGENAME.m_aTP, null);
    }

    @Override
    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        LOGGER.info("PAGE NOT FOUND " + WPECTYPE.getRequestScope().getURLEncoded());
        hCNodeList.addChild((IHCNode)new HCH1().addChild(ETextBase.MESSAGE.getDisplayText(locale)));
    }

    @Translatable
    protected static enum ETextBase implements IHasDisplayText
    {
        PAGENAME("Seite nicht gefunden", "Page not found"),
        MESSAGE("Die von Ihnen gesuchte Seite existiert leider nicht!", "The page you are looking for does not exist!");

        private final IMultilingualText m_aTP;

        private ETextBase(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

