/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.system;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.html.grouping.IHCLI;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuSeparator;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.uicore.page.AbstractWebPage;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.system.BasePageShowChildrenRenderer;
import com.helger.text.IMultilingualText;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.DefaultTreeItemWithID;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BasePageShowChildren<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPage<WPECTYPE> {
    private final IMenuTree m_aMenuTree;
    private BasePageShowChildrenRenderer m_aRenderer = new BasePageShowChildrenRenderer();

    public BasePageShowChildren(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nonnull IMenuTree iMenuTree) {
        super(string, iMultilingualText, null);
        this.m_aMenuTree = (IMenuTree)ValueEnforcer.notNull((Object)iMenuTree, (String)"MenuTree");
    }

    public BasePageShowChildren(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull IMenuTree iMenuTree) {
        this(string, (IMultilingualText)BasePageShowChildren.getAsMLT((String)string2), iMenuTree);
    }

    @Nonnull
    protected final IMenuTree getMenuTree() {
        return this.m_aMenuTree;
    }

    @Nonnull
    protected final BasePageShowChildrenRenderer getRenderer() {
        return this.m_aRenderer;
    }

    @Nonnull
    public final BasePageShowChildren<WPECTYPE> setRenderer(@Nonnull BasePageShowChildrenRenderer basePageShowChildrenRenderer) {
        this.m_aRenderer = (BasePageShowChildrenRenderer)ValueEnforcer.notNull((Object)basePageShowChildrenRenderer, (String)"Renderer");
        return this;
    }

    @Nonnull
    @OverrideOnDemand
    protected HCUL createRootUL() {
        return new HCUL();
    }

    @Nullable
    protected HCUL createChildItemTree(@Nonnull WPECTYPE WPECTYPE) {
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.m_aMenuTree.getItemWithID((Object)this.getID());
        if (defaultTreeItemWithID == null) {
            return null;
        }
        if (((IMenuObject)defaultTreeItemWithID.getData()).getMenuObjectType().isSeparator()) {
            return null;
        }
        if (((IMenuObject)defaultTreeItemWithID.getData()).getMenuObjectType().isRedirect()) {
            return null;
        }
        HCUL hCUL = this.createRootUL();
        TreeVisitor.visitTreeItem((IBasicTreeItem)defaultTreeItemWithID, new ShowChildrenCallback<WPECTYPE>(WPECTYPE, hCUL, this.m_aRenderer));
        return hCUL;
    }

    @Override
    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        WPECTYPE.getNodeList().addChild((IHCNode)this.createChildItemTree(WPECTYPE));
    }

    public static final class ShowChildrenCallback<WPECTYPE extends IWebPageExecutionContext>
    extends DefaultHierarchyVisitorCallback<DefaultTreeItemWithID<String, IMenuObject>> {
        private final WPECTYPE m_aWPEC;
        private final NonBlockingStack<HCUL> m_aStack;
        private final BasePageShowChildrenRenderer m_aRenderer;

        public ShowChildrenCallback(@Nonnull WPECTYPE WPECTYPE, @Nonnull HCUL hCUL, @Nonnull BasePageShowChildrenRenderer basePageShowChildrenRenderer) {
            ValueEnforcer.notNull(WPECTYPE, (String)"WPEC");
            ValueEnforcer.notNull((Object)hCUL, (String)"UL");
            ValueEnforcer.notNull((Object)basePageShowChildrenRenderer, (String)"Renderer");
            this.m_aWPEC = WPECTYPE;
            this.m_aStack = new NonBlockingStack((Object[])new HCUL[]{hCUL});
            this.m_aRenderer = basePageShowChildrenRenderer;
        }

        public void onLevelDown() {
            super.onLevelDown();
            this.m_aStack.push((Object)new HCUL());
        }

        public void onLevelUp() {
            HCUL hCUL = (HCUL)this.m_aStack.pop();
            if (hCUL.hasChildren()) {
                HCUL hCUL2 = (HCUL)this.m_aStack.peek();
                if (hCUL2.hasChildren()) {
                    ((HCLI)hCUL2.getLastItem()).addChild((IHCNode)hCUL);
                } else {
                    this.m_aStack.pop();
                    this.m_aStack.push((Object)hCUL);
                }
            }
            super.onLevelUp();
        }

        public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID) {
            IMenuObject iMenuObject;
            IMenuObject iMenuObject2 = iMenuObject = defaultTreeItemWithID == null ? null : (IMenuObject)defaultTreeItemWithID.getData();
            if (iMenuObject != null) {
                IHCLI iHCLI = (IHCLI)((HCUL)this.m_aStack.peek()).getLastChild();
                this.m_aRenderer.beforeAddRenderedMenuItem((IWebPageExecutionContext)this.m_aWPEC, iMenuObject, (IHCElement<?>)iHCLI);
                switch (iMenuObject.getMenuObjectType()) {
                    case SEPARATOR: {
                        iHCLI = this.m_aRenderer.renderMenuSeparator((IWebPageExecutionContext)this.m_aWPEC, (IMenuSeparator)iMenuObject);
                        break;
                    }
                    case PAGE: {
                        iHCLI = this.m_aRenderer.renderMenuItemPage((IWebPageExecutionContext)this.m_aWPEC, (IMenuItemPage)iMenuObject);
                        break;
                    }
                    case EXTERNAL: {
                        iHCLI = this.m_aRenderer.renderMenuItemExternal((IWebPageExecutionContext)this.m_aWPEC, (IMenuItemExternal)iMenuObject);
                        break;
                    }
                    case REDIRECT_TO_PAGE: {
                        iHCLI = null;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported menu object type: " + String.valueOf(iMenuObject));
                    }
                }
                IHCLI iHCLI2 = null;
                if (iHCLI != null) {
                    iHCLI2 = ((HCUL)this.m_aStack.peek()).addAndReturnItem((IHCNode)iHCLI);
                }
                this.m_aRenderer.afterAddRenderedMenuItem((IWebPageExecutionContext)this.m_aWPEC, iMenuObject, (IHCElement<?>)iHCLI2);
            }
            return EHierarchyVisitorReturn.CONTINUE;
        }
    }
}

