/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.uicore.html.toolbar.IButtonToolbar;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.IWebPageCSRFHandler;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.IWebPageFormUIHandler;
import com.helger.photon.uicore.page.handler.AbstractWebPageActionHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public abstract class AbstractWebPageActionHandlerWithQuery<DATATYPE extends IHasID<String>, WPECTYPE extends IWebPageExecutionContext, FORM_TYPE extends IHCForm<FORM_TYPE>, TOOLBAR_TYPE extends IButtonToolbar<TOOLBAR_TYPE>>
extends AbstractWebPageActionHandler<DATATYPE, WPECTYPE, FORM_TYPE, TOOLBAR_TYPE> {
    private final String m_sAction;
    private final String m_sFormID;

    public AbstractWebPageActionHandlerWithQuery(boolean bl, @Nonnull IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> iWebPageFormUIHandler, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(bl, iWebPageFormUIHandler);
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Action");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"FormID");
        this.m_sAction = string;
        this.m_sFormID = string2;
    }

    @Nonnull
    @Nonempty
    public final String getAction() {
        return this.m_sAction;
    }

    @Nonnull
    @Nonempty
    public final String getFormID() {
        return this.m_sFormID;
    }

    @OverrideOnDemand
    protected abstract void showQuery(@Nonnull WPECTYPE var1, @Nonnull FORM_TYPE var2, @Nullable DATATYPE var3);

    @OverrideOnDemand
    protected abstract void performAction(@Nonnull WPECTYPE var1, @Nullable DATATYPE var2);

    @OverrideOnDemand
    protected boolean showToolbar(@Nonnull WPECTYPE WPECTYPE, @Nullable DATATYPE DATATYPE) {
        return true;
    }

    @Nullable
    @OverrideOnDemand
    protected String getToolbarSubmitButtonText(@Nonnull Locale locale) {
        return EPhotonCoreText.BUTTON_YES.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected IIcon getToolbarSubmitButtonIcon() {
        return EDefaultIcon.YES;
    }

    @OverrideOnDemand
    protected void modifyToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, @Nullable DATATYPE DATATYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        Object TOOLBAR_TYPE = this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
        TOOLBAR_TYPE.addHiddenField("action", this.m_sAction);
        TOOLBAR_TYPE.addHiddenField("action2", "save");
        if (DATATYPE != null) {
            TOOLBAR_TYPE.addHiddenField("object", (String)DATATYPE.getID());
        }
        TOOLBAR_TYPE.addSubmitButton(this.getToolbarSubmitButtonText(locale), this.getToolbarSubmitButtonIcon());
        TOOLBAR_TYPE.addButtonNo(locale);
        this.modifyToolbar(WPECTYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @OverrideOnDemand
    protected boolean isFormSubmitted(@Nonnull WPECTYPE WPECTYPE) {
        return WPECTYPE.hasAction(this.m_sAction) && WPECTYPE.hasSubAction("save");
    }

    @Override
    @Nonnull
    public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nullable DATATYPE DATATYPE) {
        EShowList eShowList;
        boolean bl = this.isFormSubmitted(WPECTYPE);
        IWebPageCSRFHandler iWebPageCSRFHandler = WPECTYPE.getWebPage().getCSRFHandler();
        if (bl) {
            if (iWebPageCSRFHandler.checkCSRFNonce((IWebPageExecutionContext)WPECTYPE).isContinue()) {
                this.performAction(WPECTYPE, DATATYPE);
            }
            eShowList = EShowList.SHOW_LIST;
        } else {
            Object FORM_TYPE = this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE);
            WPECTYPE.getNodeList().addChild(FORM_TYPE);
            FORM_TYPE.setID(this.m_sFormID);
            FORM_TYPE.addChild((IHCNode)iWebPageCSRFHandler.createCSRFNonceField());
            this.showQuery(WPECTYPE, FORM_TYPE, DATATYPE);
            if (this.showToolbar(WPECTYPE, DATATYPE)) {
                FORM_TYPE.addChild(this.createToolbar(WPECTYPE, FORM_TYPE, DATATYPE));
            }
            eShowList = EShowList.DONT_SHOW_LIST;
        }
        return eShowList;
    }
}

