/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.uicore.html.toolbar.IButtonToolbar;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.IWebPageCSRFHandler;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.IWebPageFormUIHandler;
import com.helger.photon.uicore.page.handler.AbstractWebPageActionHandlerMulti;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.function.BiFunction;

public abstract class AbstractWebPageActionHandlerMultiWithQuery<DATATYPE extends IHasID<String>, WPECTYPE extends IWebPageExecutionContext, FORM_TYPE extends IHCForm<FORM_TYPE>, TOOLBAR_TYPE extends IButtonToolbar<TOOLBAR_TYPE>>
extends AbstractWebPageActionHandlerMulti<DATATYPE, WPECTYPE, FORM_TYPE, TOOLBAR_TYPE> {
    private final String m_sAction;
    private final String m_sFormID;

    public AbstractWebPageActionHandlerMultiWithQuery(@Nonnull IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> iWebPageFormUIHandler, @Nonnull @Nonempty String string, @Nonnull BiFunction<WPECTYPE, String, DATATYPE> biFunction, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        super(iWebPageFormUIHandler, string, biFunction);
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Action");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"FormID");
        this.m_sAction = string2;
        this.m_sFormID = string3;
    }

    @OverrideOnDemand
    protected abstract void showQuery(@Nonnull WPECTYPE var1, @Nonnull FORM_TYPE var2, @Nonnull ICommonsList<DATATYPE> var3);

    @OverrideOnDemand
    protected abstract void performAction(@Nonnull WPECTYPE var1, @Nonnull ICommonsList<DATATYPE> var2);

    @OverrideOnDemand
    protected boolean showToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull ICommonsList<DATATYPE> iCommonsList) {
        return true;
    }

    @Nullable
    @OverrideOnDemand
    protected String getToolbarSubmitButtonText(@Nonnull Locale locale) {
        return EPhotonCoreText.BUTTON_YES.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected IIcon getToolbarSubmitButtonIcon() {
        return EDefaultIcon.YES;
    }

    @OverrideOnDemand
    protected void modifyToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, @Nonnull ICommonsList<DATATYPE> iCommonsList) {
        Locale locale = WPECTYPE.getDisplayLocale();
        Object TOOLBAR_TYPE = this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
        TOOLBAR_TYPE.addHiddenField("action", this.m_sAction);
        TOOLBAR_TYPE.addHiddenField("action2", "save");
        for (IHasID iHasID : iCommonsList) {
            TOOLBAR_TYPE.addHiddenField(this.getFieldName(), (String)iHasID.getID());
        }
        TOOLBAR_TYPE.addSubmitButton(this.getToolbarSubmitButtonText(locale), this.getToolbarSubmitButtonIcon());
        TOOLBAR_TYPE.addButtonNo(locale);
        this.modifyToolbar(WPECTYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @OverrideOnDemand
    protected boolean isFormSubmitted(@Nonnull WPECTYPE WPECTYPE) {
        return WPECTYPE.hasAction(this.m_sAction) && WPECTYPE.hasSubAction("save");
    }

    @Override
    @Nonnull
    public EShowList handleMultiAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull ICommonsList<DATATYPE> iCommonsList) {
        EShowList eShowList;
        boolean bl = this.isFormSubmitted(WPECTYPE);
        IWebPageCSRFHandler iWebPageCSRFHandler = WPECTYPE.getWebPage().getCSRFHandler();
        if (bl) {
            if (iWebPageCSRFHandler.checkCSRFNonce((IWebPageExecutionContext)WPECTYPE).isContinue()) {
                this.performAction(WPECTYPE, iCommonsList);
            }
            eShowList = EShowList.SHOW_LIST;
        } else {
            Object FORM_TYPE = this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE);
            WPECTYPE.getNodeList().addChild(FORM_TYPE);
            FORM_TYPE.setID(this.m_sFormID);
            FORM_TYPE.addChild((IHCNode)iWebPageCSRFHandler.createCSRFNonceField());
            this.showQuery(WPECTYPE, FORM_TYPE, iCommonsList);
            if (this.showToolbar(WPECTYPE, iCommonsList)) {
                FORM_TYPE.addChild(this.createToolbar(WPECTYPE, FORM_TYPE, iCommonsList));
            }
            eShowList = EShowList.DONT_SHOW_LIST;
        }
        return eShowList;
    }
}

