/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.photon.uicore.html.toolbar.IButtonToolbar;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.IWebPageFormUIHandler;
import com.helger.photon.uicore.page.handler.IWebPageActionHandlerMulti;
import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;

public abstract class AbstractWebPageActionHandlerMulti<DATATYPE extends IHasID<String>, WPECTYPE extends IWebPageExecutionContext, FORM_TYPE extends IHCForm<FORM_TYPE>, TOOLBAR_TYPE extends IButtonToolbar<TOOLBAR_TYPE>>
implements IWebPageActionHandlerMulti<DATATYPE, WPECTYPE> {
    private final IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> m_aUIHandler;
    private final String m_sFieldName;
    private final BiFunction<WPECTYPE, String, DATATYPE> m_aResolver;

    protected AbstractWebPageActionHandlerMulti(@Nonnull IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> iWebPageFormUIHandler, @Nonnull @Nonempty String string, @Nonnull BiFunction<WPECTYPE, String, DATATYPE> biFunction) {
        this.m_aUIHandler = (IWebPageFormUIHandler)ValueEnforcer.notNull(iWebPageFormUIHandler, (String)"UIHandler");
        this.m_sFieldName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        this.m_aResolver = (BiFunction)ValueEnforcer.notNull(biFunction, (String)"Resolver");
    }

    @Nonnull
    protected final IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> getUIHandler() {
        return this.m_aUIHandler;
    }

    @Nonnull
    @Nonempty
    protected final String getFieldName() {
        return this.m_sFieldName;
    }

    @Nonnull
    @Nonempty
    protected final BiFunction<WPECTYPE, String, DATATYPE> getResolver() {
        return this.m_aResolver;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DATATYPE> getAllSelectedObjects(@Nonnull WPECTYPE WPECTYPE) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsList iCommonsList = WPECTYPE.params().getAsStringList((Object)this.m_sFieldName);
        if (iCommonsList != null) {
            for (String string : iCommonsList) {
                commonsArrayList.addIfNotNull((Object)((IHasID)this.m_aResolver.apply(WPECTYPE, string)));
            }
        }
        return commonsArrayList;
    }

    @Override
    public boolean isSelectedObjectRequired() {
        return false;
    }

    @Override
    @Nonnull
    public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, DATATYPE DATATYPE) {
        ICommonsList<DATATYPE> iCommonsList = this.getAllSelectedObjects(WPECTYPE);
        return this.handleMultiAction(WPECTYPE, iCommonsList);
    }
}

