/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.external;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLVersion;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.url.protocol.URLProtocolRegistry;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.IMicroText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PageViewExternalHTMLCleanser
extends DefaultHierarchyVisitorCallback<IMicroNode> {
    public static final boolean DEFAULT_REMOVE_COMMENTS = true;
    public static final boolean DEFAULT_CLEAN_TEXTS = true;
    private String m_sServerPrefixPath = ServletContextPathHolder.getContextPath() + "/";
    private final EHTMLVersion m_eHTMLVersion;
    private final String m_sNamespaceURI;
    private boolean m_bRemoveComments = true;
    private boolean m_bCleanTexts = true;
    private static final IMicroQName[] LINK_ATTR_NAMES = new IMicroQName[]{CHTMLAttributes.SRC, CHTMLAttributes.HREF};

    public PageViewExternalHTMLCleanser() {
        this(null);
    }

    public PageViewExternalHTMLCleanser(@Nullable EHTMLVersion eHTMLVersion) {
        this.m_eHTMLVersion = eHTMLVersion;
        this.m_sNamespaceURI = eHTMLVersion == null ? null : eHTMLVersion.getNamespaceURI();
    }

    @Nonnull
    @Nonempty
    public String getServerPrefixPath() {
        return this.m_sServerPrefixPath;
    }

    @Nonnull
    public PageViewExternalHTMLCleanser setServerPrefixPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ServerPrefixPath");
        ValueEnforcer.isTrue((boolean)string.endsWith("/"), (String)"ServerPrefixPath must end with a slash");
        this.m_sServerPrefixPath = string;
        return this;
    }

    @Nullable
    public EHTMLVersion getHTMLVersion() {
        return this.m_eHTMLVersion;
    }

    @Nullable
    public String getHTMLNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    public boolean isRemoveComments() {
        return this.m_bRemoveComments;
    }

    @Nonnull
    public PageViewExternalHTMLCleanser setRemoveComments(boolean bl) {
        this.m_bRemoveComments = bl;
        return this;
    }

    public boolean isCleanTexts() {
        return this.m_bCleanTexts;
    }

    @Nonnull
    public PageViewExternalHTMLCleanser setCleanTexts(boolean bl) {
        this.m_bCleanTexts = bl;
        return this;
    }

    @OverrideOnDemand
    protected boolean linkNeedsContextPath(@Nullable String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(this.m_sServerPrefixPath)) {
            return false;
        }
        return !URLProtocolRegistry.getInstance().hasKnownProtocol(string) && !string.startsWith("#");
    }

    public EHierarchyVisitorReturn onItemBeforeChildren(IMicroNode iMicroNode) {
        IMicroText iMicroText;
        String string;
        if (iMicroNode instanceof IMicroComment) {
            if (this.m_bRemoveComments) {
                iMicroNode.getParent().removeChild(iMicroNode);
            }
        } else if (iMicroNode instanceof IMicroElement) {
            String string2;
            IMicroElement iMicroElement = (IMicroElement)iMicroNode;
            iMicroElement.setNamespaceURI(this.m_sNamespaceURI);
            iMicroElement.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
            String string3 = iMicroElement.getAttributeValue(CHTMLAttributes.ROWSPAN);
            if ("1".equals(string3)) {
                iMicroElement.removeAttribute(CHTMLAttributes.ROWSPAN);
            }
            if ("1".equals(string2 = iMicroElement.getAttributeValue(CHTMLAttributes.COLSPAN))) {
                iMicroElement.removeAttribute(CHTMLAttributes.COLSPAN);
            }
            for (IMicroQName iMicroQName : LINK_ATTR_NAMES) {
                Object object = iMicroElement.getAttributeValue(iMicroQName);
                if (object == null || !this.linkNeedsContextPath((String)object)) continue;
                object = this.m_sServerPrefixPath + (String)object;
                iMicroElement.setAttribute(iMicroQName, (String)object);
            }
            if (EHTMLElement.A.getElementName().equalsIgnoreCase(iMicroElement.getTagName())) {
                iMicroElement.removeAttribute(CHTMLAttributes.SHAPE);
            }
            if (EHTMLElement.isTagThatMayNotBeSelfClosed((String)iMicroElement.getTagName()) && iMicroElement.getChildCount() == 0) {
                iMicroElement.addText((CharSequence)"");
            }
        } else if (iMicroNode instanceof IMicroText && this.m_bCleanTexts && StringHelper.isNotEmpty((String)(string = (iMicroText = (IMicroText)iMicroNode).getNodeValue()))) {
            String string4 = string;
            string4 = StringReplace.replaceAll((String)string4, (String)"\r\n", (CharSequence)" ");
            string4 = StringReplace.replaceAll((String)string4, (String)"\r", (CharSequence)"");
            string4 = StringReplace.replaceAll((String)string4, (char)'\n', (char)' ');
            string4 = StringReplace.replaceAll((String)string4, (char)'\t', (char)' ');
            if (!string.equals(string4 = StringReplace.replaceAllRepeatedly((String)string4, (String)"  ", (String)" "))) {
                iMicroText.setData((CharSequence)string4);
            }
        }
        return EHierarchyVisitorReturn.CONTINUE;
    }
}

