/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.external;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.HCDOMWrapper;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.external.AbstractWebPageResourceContent;
import com.helger.text.IMultilingualText;
import com.helger.text.locale.LocaleHelper;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

@ThreadSafe
public class BasePageViewExternalMultilingual<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageResourceContent<WPECTYPE> {
    private final Locale m_aDefaultLocale;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Locale, ContentPerLocale> m_aContent = new CommonsHashMap();

    @Nonnull
    private IMicroContainer _readFromResource(@Nonnull IReadableResource iReadableResource) {
        boolean bl = this.hasContentCleanser();
        IMicroContainer iMicroContainer = BasePageViewExternalMultilingual.readHTMLPageFragment(iReadableResource, !bl);
        if (bl) {
            this.getContentCleanser().accept(iMicroContainer);
        }
        return iMicroContainer;
    }

    private void _init(@Nonnull Map<Locale, IReadableResource> map) {
        for (Map.Entry<Locale, IReadableResource> entry : map.entrySet()) {
            Locale locale = entry.getKey();
            IReadableResource iReadableResource = entry.getValue();
            IMicroContainer iMicroContainer = this._readFromResource(iReadableResource);
            this.m_aContent.put((Object)locale, (Object)new ContentPerLocale(iReadableResource, iMicroContainer));
        }
    }

    public BasePageViewExternalMultilingual(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull Map<Locale, IReadableResource> map, @Nonnull Locale locale, @Nullable Consumer<? super IMicroContainer> consumer) {
        this(string, (IMultilingualText)BasePageViewExternalMultilingual.getAsMLT((String)string2), map, locale, consumer);
    }

    public BasePageViewExternalMultilingual(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nonnull Map<Locale, IReadableResource> map, @Nonnull Locale locale, @Nullable Consumer<? super IMicroContainer> consumer) {
        super(string, iMultilingualText, consumer);
        ValueEnforcer.notEmpty(map, (String)"Resources");
        this.m_aDefaultLocale = (Locale)ValueEnforcer.notNull((Object)locale, (String)"DefaultLocale");
        if (!map.containsKey(locale)) {
            throw new IllegalArgumentException("The provided default locale " + String.valueOf(locale) + " is not present in the resource locales: " + String.valueOf(map.keySet()));
        }
        this._init(map);
    }

    @Nullable
    public IMicroContainer getParsedContent(@Nullable Locale locale) {
        if (locale == null) {
            return null;
        }
        return (IMicroContainer)this.m_aRWLock.readLockedGet(() -> {
            Locale locale2 = LocaleHelper.getLocaleToUseOrNull((Locale)locale, (Collection)this.m_aContent.keySet());
            if (locale2 == null) {
                return null;
            }
            ContentPerLocale contentPerLocale = (ContentPerLocale)this.m_aContent.get((Object)locale2);
            if (contentPerLocale == null) {
                return null;
            }
            return contentPerLocale.getContainerClone();
        });
    }

    @Override
    public void updateFromResource() {
        this.m_aRWLock.writeLocked(() -> {
            for (Map.Entry entry : this.m_aContent.entrySet()) {
                ContentPerLocale contentPerLocale = (ContentPerLocale)entry.getValue();
                IMicroContainer iMicroContainer = this._readFromResource(contentPerLocale.getResource());
                contentPerLocale.setContainer(iMicroContainer);
            }
        });
    }

    @Override
    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        boolean bl = this.isReadEveryTime();
        IMicroNode iMicroNode = (IMicroNode)this.m_aRWLock.readLockedGet(() -> {
            Locale locale2 = LocaleHelper.getLocaleToUseOrFallback((Locale)locale, (Collection)this.m_aContent.keySet(), (Locale)this.m_aDefaultLocale);
            ContentPerLocale contentPerLocale = (ContentPerLocale)this.m_aContent.get((Object)locale2);
            if (contentPerLocale == null) {
                throw new IllegalStateException("Found no content for locale " + String.valueOf(locale2) + " and display locale " + String.valueOf(locale) + " in page " + this.getID());
            }
            return bl ? this._readFromResource(contentPerLocale.getResource()) : contentPerLocale.getContainerClone();
        });
        hCNodeList.addChild((IHCNode)new HCDOMWrapper(iMicroNode));
    }

    @NotThreadSafe
    private static final class ContentPerLocale
    implements Serializable {
        private final IReadableResource m_aResource;
        private IMicroContainer m_aCont;

        public ContentPerLocale(@Nonnull IReadableResource iReadableResource, @Nonnull IMicroContainer iMicroContainer) {
            this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
            this.setContainer(iMicroContainer);
        }

        @Nonnull
        public IReadableResource getResource() {
            return this.m_aResource;
        }

        @Nonnull
        @ReturnsMutableCopy
        public IMicroContainer getContainerClone() {
            return this.m_aCont.getClone();
        }

        public void setContainer(@Nonnull IMicroContainer iMicroContainer) {
            this.m_aCont = (IMicroContainer)ValueEnforcer.notNull((Object)iMicroContainer, (String)"Cont");
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aResource).append("cont", (Object)this.m_aCont).getToString();
        }
    }
}

