/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.external;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.HCDOMWrapper;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.external.AbstractWebPageResourceContent;
import com.helger.text.IMultilingualText;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;

@ThreadSafe
public class BasePageViewExternal<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageResourceContent<WPECTYPE> {
    protected final IReadableResource m_aResource;
    @GuardedBy(value="m_aRWLock")
    protected IMicroContainer m_aParsedContent;

    @Nonnull
    private IMicroContainer _readFromResource(@Nonnull IReadableResource iReadableResource) {
        boolean bl = this.hasContentCleanser();
        IMicroContainer iMicroContainer = BasePageViewExternal.readHTMLPageFragment(iReadableResource, !bl);
        if (bl) {
            this.getContentCleanser().accept(iMicroContainer);
        }
        return iMicroContainer;
    }

    public BasePageViewExternal(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull IReadableResource iReadableResource, @Nullable Consumer<? super IMicroContainer> consumer) {
        this(string, (IMultilingualText)BasePageViewExternal.getAsMLT((String)string2), iReadableResource, consumer);
    }

    public BasePageViewExternal(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nonnull IReadableResource iReadableResource, @Nullable Consumer<? super IMicroContainer> consumer) {
        super(string, iMultilingualText, consumer);
        this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aParsedContent = this._readFromResource(iReadableResource);
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IMicroContainer getParsedContent() {
        return (IMicroContainer)this.m_aRWLock.readLockedGet(() -> ((IMicroContainer)this.m_aParsedContent).getClone());
    }

    @Override
    public void updateFromResource() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aParsedContent = this._readFromResource(this.m_aResource);
        });
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        boolean bl = this.isReadEveryTime();
        IMicroNode iMicroNode = (IMicroNode)this.m_aRWLock.readLockedGet(() -> bl ? this._readFromResource(this.m_aResource) : this.m_aParsedContent);
        hCNodeList.addChild((IHCNode)new HCDOMWrapper(iMicroNode));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Resource", (Object)this.m_aResource).append("ParsedContent", (Object)this.m_aParsedContent).getToString();
    }
}

