/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page.external;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.parser.XHTMLParser;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.uicore.page.AbstractWebPage;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.external.IWebPageResourceContent;
import com.helger.photon.uicore.page.external.PageViewExternalHTMLCleanser;
import com.helger.text.IMultilingualText;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.util.MicroVisitor;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

@ThreadSafe
public abstract class AbstractWebPageResourceContent<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPage<WPECTYPE>
implements IWebPageResourceContent {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final boolean DEFAULT_READ_EVERY_TIME = GlobalDebug.isDebugMode();
    private static final AtomicBoolean READ_EVERY_TIME = new AtomicBoolean(DEFAULT_READ_EVERY_TIME);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final Consumer<? super IMicroContainer> m_aContentCleanser;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bReadEveryTime = AbstractWebPageResourceContent.isDefaultReadEveryTime();

    public static boolean isDefaultReadEveryTime() {
        return READ_EVERY_TIME.get();
    }

    public static void setDefaultReadEveryTime(boolean bl) {
        READ_EVERY_TIME.set(bl);
    }

    @Nonnull
    public static IMicroContainer readHTMLPageFragment(@Nonnull IReadableResource iReadableResource, boolean bl) {
        return AbstractWebPageResourceContent.readHTMLPageFragment(iReadableResource, DEFAULT_CHARSET, HCSettings.getConversionSettings().getHTMLVersion(), null, bl);
    }

    @Nonnull
    public static IMicroContainer readHTMLPageFragment(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull EHTMLVersion eHTMLVersion, @Nullable SAXReaderSettings sAXReaderSettings, boolean bl) {
        IMicroContainer iMicroContainer;
        String string = StreamHelper.getAllBytesAsString((IHasInputStream)iReadableResource, (Charset)charset);
        if (string == null) {
            throw new IllegalStateException("Failed to read resource " + iReadableResource.toString());
        }
        EHTMLVersion eHTMLVersion2 = eHTMLVersion.isAtLeastHTML5() ? EHTMLVersion.XHTML11 : eHTMLVersion;
        XHTMLParser xHTMLParser = new XHTMLParser(eHTMLVersion2);
        if (sAXReaderSettings != null) {
            xHTMLParser.setSAXReaderSettings((ISAXReaderSettings)sAXReaderSettings);
        }
        if ((iMicroContainer = xHTMLParser.unescapeXHTMLFragment(string)) == null) {
            throw new IllegalStateException("Failed to parse HTML code of resource " + iReadableResource.toString());
        }
        if (bl) {
            MicroVisitor.visit((IMicroNode)iMicroContainer, (IHierarchyVisitorCallback)new PageViewExternalHTMLCleanser(eHTMLVersion));
        }
        return iMicroContainer;
    }

    public AbstractWebPageResourceContent(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable Consumer<? super IMicroContainer> consumer) {
        super(string, iMultilingualText, null);
        this.m_aContentCleanser = consumer;
    }

    @Override
    @Nullable
    public final Consumer<? super IMicroContainer> getContentCleanser() {
        return this.m_aContentCleanser;
    }

    public final boolean hasContentCleanser() {
        return this.m_aContentCleanser != null;
    }

    @Override
    public final boolean isReadEveryTime() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bReadEveryTime);
    }

    @Override
    @Nonnull
    public final AbstractWebPageResourceContent<WPECTYPE> setReadEveryTime(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bReadEveryTime = bl;
        });
        return this;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ContentCleanser", this.m_aContentCleanser).append("ReadEveryTime", this.m_bReadEveryTime).getToString();
    }
}

