/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.execcontext.LayoutExecutionContext;
import com.helger.photon.uicore.page.IWebPage;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class WebPageExecutionContext
extends LayoutExecutionContext
implements IWebPageExecutionContext {
    private final IWebPage<? extends IWebPageExecutionContext> m_aWebPage;
    private final HCNodeList m_aNodeList = new HCNodeList();

    public WebPageExecutionContext(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IWebPage<? extends IWebPageExecutionContext> iWebPage) {
        super(iLayoutExecutionContext);
        this.m_aWebPage = (IWebPage)ValueEnforcer.notNull(iWebPage, (String)"WebPage");
    }

    @Override
    @Nonnull
    public final IWebPage<? extends IWebPageExecutionContext> getWebPage() {
        return this.m_aWebPage;
    }

    @Override
    @Nonnull
    public final HCNodeList getNodeList() {
        return this.m_aNodeList;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("webPage", this.m_aWebPage).append("nodeList", (Object)this.m_aNodeList).getToString();
    }
}

