/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EContinue;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.photon.app.csrf.CSRFSessionManager;
import com.helger.photon.uicore.page.ICSRFErrorHandler;
import com.helger.photon.uicore.page.IWebPageCSRFHandler;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.LoggingCSRFErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class WebPageCSRFHandler
implements IWebPageCSRFHandler {
    public static final boolean DEFAULT_CSRF_PREVENTION_ENABLED = true;
    public static final WebPageCSRFHandler INSTANCE = new WebPageCSRFHandler();
    private boolean m_bCSRFPreventionEnabled = true;
    private ICSRFErrorHandler m_aErrorHdl = new LoggingCSRFErrorHandler();

    protected WebPageCSRFHandler() {
    }

    @Override
    public final boolean isCSRFPreventionEnabled() {
        return this.m_bCSRFPreventionEnabled;
    }

    @Nonnull
    public final WebPageCSRFHandler setCSRFPreventionEnabled(boolean bl) {
        this.m_bCSRFPreventionEnabled = bl;
        return this;
    }

    @Nonnull
    public final ICSRFErrorHandler getCSRFErrorHandler() {
        return this.m_aErrorHdl;
    }

    @Nonnull
    public final WebPageCSRFHandler setCSRFErrorHandler(@Nonnull ICSRFErrorHandler iCSRFErrorHandler) {
        ValueEnforcer.notNull((Object)iCSRFErrorHandler, (String)"ErrorHdl");
        this.m_aErrorHdl = iCSRFErrorHandler;
        return this;
    }

    @Override
    @Nonnull
    public EContinue checkCSRFNonce(@Nonnull IWebPageExecutionContext iWebPageExecutionContext) {
        String string;
        CSRFSessionManager cSRFSessionManager;
        if (this.m_bCSRFPreventionEnabled && !(cSRFSessionManager = CSRFSessionManager.getInstance()).isExpectedNonce(string = iWebPageExecutionContext.params().getAsString((Object)"$ph_nonce"))) {
            this.m_aErrorHdl.onCSRFError(iWebPageExecutionContext, string, cSRFSessionManager.getNonce());
            cSRFSessionManager.generateNewNonce();
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Override
    @Nullable
    public HCHiddenField createCSRFNonceField() {
        if (this.m_bCSRFPreventionEnabled) {
            CSRFSessionManager cSRFSessionManager = CSRFSessionManager.getInstance();
            return new HCHiddenField("$ph_nonce", cSRFSessionManager.getNonce());
        }
        return null;
    }
}

