/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EWebPageFormAction implements IHasID<String>
{
    SHOW_LIST("$none$"),
    VIEW("view"),
    CREATE("create"),
    EDIT("edit"),
    COPY("copy"),
    DELETE("delete"),
    UNDELETE("undelete"),
    CUSTOM("$custom$");

    public static final EWebPageFormAction DEFAULT;
    private final String m_sID;

    private EWebPageFormAction(String string2) {
        this.m_sID = string2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    public boolean isShowList() {
        return this == SHOW_LIST;
    }

    public boolean isView() {
        return this == VIEW;
    }

    public boolean isCreate() {
        return this == CREATE;
    }

    public boolean isEdit() {
        return this == EDIT;
    }

    public boolean isCopy() {
        return this == COPY;
    }

    public boolean isDelete() {
        return this == DELETE;
    }

    public boolean isUndelete() {
        return this == UNDELETE;
    }

    public boolean isCustom() {
        return this == CUSTOM;
    }

    public boolean isCreating() {
        return this == CREATE || this == COPY;
    }

    public boolean isModifying() {
        return this == EDIT || this == DELETE || this == UNDELETE;
    }

    public boolean isReadonly() {
        return this == SHOW_LIST || this == VIEW;
    }

    public boolean isWriting() {
        return this.isCreating() || this.isModifying();
    }

    @Nullable
    public static EWebPageFormAction getFromIDOrNull(@Nullable String string) {
        return (EWebPageFormAction)EnumHelper.getFromIDOrNull(EWebPageFormAction.class, (Object)string);
    }

    @Nullable
    public static EWebPageFormAction getFromIDOrDefault(@Nullable String string, @Nullable EWebPageFormAction eWebPageFormAction) {
        return (EWebPageFormAction)EnumHelper.getFromIDOrDefault(EWebPageFormAction.class, (Object)string, (Enum)eWebPageFormAction);
    }

    static {
        DEFAULT = SHOW_LIST;
    }
}

